/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.StringJoiner;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.AbstractRepositoryApiRequestToConfigurationConverter;
import org.sonatype.nexus.repository.rest.api.ApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.AuthorizingRepositoryManager;
import org.sonatype.nexus.repository.rest.api.FormatAndType;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.AbstractRepositoryApiRequest;
import org.sonatype.nexus.repository.view.handlers.HighAvailabilitySupportChecker;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class AbstractRepositoriesApiResource<T extends AbstractRepositoryApiRequest>
extends ComponentSupport
implements Resource {
    private AuthorizingRepositoryManager authorizingRepositoryManager;
    private AbstractRepositoryApiRequestToConfigurationConverter<T> configurationAdapter;
    private Map<String, ApiRepositoryAdapter> convertersByFormat;
    private ApiRepositoryAdapter defaultAdapter;
    protected HighAvailabilitySupportChecker highAvailabilitySupportChecker;

    @Inject
    public void setHighAvailabilitySupportChecker(HighAvailabilitySupportChecker highAvailabilitySupportChecker) {
        this.highAvailabilitySupportChecker = highAvailabilitySupportChecker;
    }

    @Inject
    public void setAuthorizingRepositoryManager(AuthorizingRepositoryManager authorizingRepositoryManager) {
        this.authorizingRepositoryManager = (AuthorizingRepositoryManager)Preconditions.checkNotNull((Object)authorizingRepositoryManager);
    }

    @Inject
    public void setConfigurationAdapter(AbstractRepositoryApiRequestToConfigurationConverter<T> configurationAdapter) {
        this.configurationAdapter = (AbstractRepositoryApiRequestToConfigurationConverter)Preconditions.checkNotNull(configurationAdapter);
    }

    @Inject
    public void setConvertersByFormat(Map<String, ApiRepositoryAdapter> convertersByFormat) {
        this.convertersByFormat = (Map)Preconditions.checkNotNull(convertersByFormat);
    }

    @Inject
    public void setDefaultAdapter(ApiRepositoryAdapter defaultAdapter) {
        this.defaultAdapter = (ApiRepositoryAdapter)Preconditions.checkNotNull((Object)defaultAdapter);
    }

    /*
     * Unable to fully structure code
     */
    @POST
    @RequiresAuthentication
    @Validate
    public Response createRepository(@NotNull @Valid T request) {
        this.verifyAPIEnabled(request.getFormat());
        try {
            this.authorizingRepositoryManager.create(this.configurationAdapter.convert(request));
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (ConstraintViolationException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            stringJoiner = new StringJoiner("\n", "\"", "\"");
            stringJoiner.add(e.getMessage());
            var7_5 = e.getSuppressed();
            var6_6 = var7_5.length;
            var5_7 = 0;
            ** while (var5_7 < var6_6)
        }
lbl-1000:
        // 1 sources

        {
            t = var7_5[var5_7];
            stringJoiner.add(t.getMessage());
            ++var5_7;
            continue;
        }
lbl20:
        // 1 sources

        message = stringJoiner.toString();
        this.log.debug("Failed to create a new repository via REST: {}", (Object)message, (Object)e);
        throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)message, "application/json");
    }

    /*
     * Unable to fully structure code
     */
    @PUT
    @Path(value="/{repositoryName}")
    @RequiresAuthentication
    @Validate
    public Response updateRepository(@NotNull @Valid T request, @PathParam(value="repositoryName") String repositoryName) {
        try {
            newConfiguration = this.configurationAdapter.convert(request);
            this.ensureRepositoryNameMatches(request, repositoryName);
            updated = this.authorizingRepositoryManager.update(newConfiguration);
            status = updated != false ? Response.Status.NO_CONTENT : Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).build();
        }
        catch (ConstraintViolationException | AuthenticationException | AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            stringJoiner = new StringJoiner("\n", "\"", "\"");
            stringJoiner.add(e.getMessage());
            var8_10 = e.getSuppressed();
            var7_11 = var8_10.length;
            var6_12 = 0;
            ** while (var6_12 < var7_11)
        }
lbl-1000:
        // 1 sources

        {
            t = var8_10[var6_12];
            stringJoiner.add(t.getMessage());
            ++var6_12;
            continue;
        }
lbl22:
        // 1 sources

        message = stringJoiner.toString();
        this.log.debug("Failed to edit a repository via REST: {}", (Object)message, (Object)e);
        throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)message, "application/json");
    }

    @GET
    @Path(value="/{repositoryName}")
    @RequiresAuthentication
    @Validate
    @ApiOperation(value="Get repository")
    public AbstractApiRepository getRepository(@ApiParam(hidden=true) @BeanParam FormatAndType formatAndType, @PathParam(value="repositoryName") String repositoryName) {
        return this.authorizingRepositoryManager.getRepositoryWithAdmin(repositoryName).filter(r -> r.getType().getValue().equals(formatAndType.type()) && r.getFormat().getValue().equals(formatAndType.format())).map(r -> this.convertersByFormat.getOrDefault(r.getFormat().toString(), this.defaultAdapter).adapt((Repository)r)).orElseThrow(() -> new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)"\"Repository not found\"", "application/json"));
    }

    public boolean isApiEnabled() {
        return true;
    }

    private void ensureRepositoryNameMatches(T request, String repositoryName) {
        if (!repositoryName.equals(((AbstractRepositoryApiRequest)request).getName())) {
            throw new ValidationErrorsException("name", "Renaming a repository is not supported");
        }
    }

    private void verifyAPIEnabled(String format) {
        if (!this.isApiEnabled()) {
            String message = String.format("Format %s is disabled in High Availability", format);
            throw new WebApplicationMessageException(Response.Status.METHOD_NOT_ALLOWED, (Object)message, "application/json");
        }
    }
}

