/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sonatype.nexus.repository.rest.SearchFieldSupport;
import org.sonatype.nexus.repository.rest.sql.UnsupportedSearchField;

public class SearchMapping {
    private final String attribute;
    private final String alias;
    private final String description;
    private final SearchFieldSupport field;

    public SearchMapping(String alias, String attribute, String description, SearchFieldSupport field) {
        this.alias = (String)Preconditions.checkNotNull((Object)alias);
        this.attribute = (String)Preconditions.checkNotNull((Object)attribute);
        this.description = (String)Preconditions.checkNotNull((Object)description);
        this.field = (SearchFieldSupport)Preconditions.checkNotNull((Object)field);
    }

    public SearchMapping(String alias, String attribute, String description) {
        this(alias, attribute, description, UnsupportedSearchField.INSTANCE);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchFieldSupport getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchMapping that = (SearchMapping)o;
        return Objects.equals(this.attribute, that.attribute) && Objects.equals(this.alias, that.alias) && Objects.equals(this.description, that.description) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.attribute, this.alias, this.description, this.field);
    }

    public String toString() {
        return "SearchMapping{attribute='" + this.attribute + '\'' + ", alias='" + this.alias + '\'' + ", description='" + this.description + '\'' + ", field='" + this.field + '\'' + '}';
    }
}

