/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest;

import com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class SearchFieldSupport {
    private final String table;
    private final String columnName;

    protected SearchFieldSupport(String table, String columnName) {
        this.table = (String)Preconditions.checkNotNull((Object)table);
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTable() {
        return this.table;
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.table);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchFieldSupport other = (SearchFieldSupport)obj;
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.table, other.table);
    }

    public String toString() {
        return String.valueOf(this.table) + '.' + this.columnName;
    }
}

