/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.replication;

import com.google.common.hash.HashCode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.hash.HashAlgorithm;

public class ReplicationUtils {
    public static final String CHECKSUM = "checksum";
    private static final List<HashAlgorithm> HASH_ALGORITHMS = Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA256, HashAlgorithm.SHA1, HashAlgorithm.SHA512);

    private ReplicationUtils() {
    }

    public static Map<HashAlgorithm, HashCode> getChecksumsFromProperties(Map<String, Object> attributesMap) {
        HashMap<HashAlgorithm, HashCode> checksums = new HashMap<HashAlgorithm, HashCode>();
        for (HashAlgorithm hashAlgorithm : HASH_ALGORITHMS) {
            ReplicationUtils.getChecksumAttribute(attributesMap, hashAlgorithm.name()).ifPresent(value -> {
                HashCode hashCode = checksums.put(hashAlgorithm, HashCode.fromString((String)value));
            });
        }
        return checksums;
    }

    private static Optional<String> getChecksumAttribute(Map<String, Object> attributesMap, String name) {
        try {
            String value = ((Map)attributesMap.get(CHECKSUM)).get(name).toString();
            if (StringUtils.isEmpty((String)value)) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

