/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.replication;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.replication.BlobEventType;
import org.sonatype.nexus.repository.replication.ReplicationIngester;
import org.sonatype.nexus.repository.replication.ReplicationIngesterHelper;
import org.sonatype.nexus.repository.replication.ReplicationIngestionException;

public abstract class ReplicationIngesterSupport
extends ComponentSupport
implements ReplicationIngester {
    private final BlobStoreManager blobStoreManager;
    private final ReplicationIngesterHelper replicationIngesterHelper;

    public ReplicationIngesterSupport(BlobStoreManager blobstoreManager, ReplicationIngesterHelper replicationIngesterHelper) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobstoreManager);
        this.replicationIngesterHelper = (ReplicationIngesterHelper)Preconditions.checkNotNull((Object)replicationIngesterHelper);
    }

    public Map<String, Object> extractAssetAttributesFromProperties(Properties props) {
        return this.extractAttributesFromProperties(props, "@attributes.asset.");
    }

    public Map<String, Object> extractComponentAttributesFromProperties(Properties props) {
        return this.extractAttributesFromProperties(props, "@attributes.component.");
    }

    private Map<String, Object> extractAttributesFromProperties(Properties props, String prefix) {
        HashMap<String, Object> backingAssetAttributes = new HashMap<String, Object>();
        Set<String> keys = props.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            String value = props.getProperty(key);
            key = key.substring(prefix.length());
            String[] flattenedAttributesParts = key.split("\\.");
            key = flattenedAttributesParts[0];
            this.unflattenAttributes(backingAssetAttributes, flattenedAttributesParts[0], Arrays.copyOfRange(flattenedAttributesParts, 1, flattenedAttributesParts.length), this.convertAttributeValue(key, value));
        }
        return backingAssetAttributes;
    }

    @Override
    public void ingestBlob(String blobIdString, String blobStoreId, String repositoryName, BlobEventType eventType) throws ReplicationIngestionException {
        BlobId blobId = new BlobId(blobIdString);
        BlobStore blobStore = this.blobStoreManager.get(blobStoreId);
        this.validateBlobStore(blobStore, blobId, blobStoreId);
        Blob blob = blobStore.get(blobId);
        BlobAttributes blobAttributes = blobStore.getBlobAttributes(blobId);
        this.validateBlob(blob, blobAttributes, blobId);
        if (eventType.equals((Object)BlobEventType.DELETED)) {
            this.log.info("Ingesting a delete for blob {} in repository {} and blob store {}.", new Object[]{blobIdString, repositoryName, blobStoreId});
            String path = (String)blobAttributes.getHeaders().get("BlobStore.blob-name");
            this.replicationIngesterHelper.deleteReplication(path, repositoryName);
            return;
        }
        Map<String, Object> assetAttributes = this.extractAssetAttributesFromProperties(blobAttributes.getProperties());
        Map<String, Object> componentAttributes = this.extractComponentAttributesFromProperties(blobAttributes.getProperties());
        try {
            this.log.debug("Ingesting blob {} in repository {} and blob store {}.", new Object[]{blobIdString, repositoryName, blobStoreId});
            this.replicationIngesterHelper.replicate(blobStoreId, blob, assetAttributes, componentAttributes, repositoryName, blobStoreId);
        }
        catch (IOException e) {
            throw new ReplicationIngestionException(String.format("Could not ingest blob %s for repository %s in blobstore %s.", blobIdString, repositoryName, blobStoreId), e);
        }
    }

    private void validateBlobStore(BlobStore blobStore, BlobId blobId, String blobStoreId) {
        if (blobStore == null) {
            throw new ReplicationIngestionException(String.format("Can't ingest blob %s, the blob store %s doesn't exist", blobId.asUniqueString(), blobStoreId));
        }
    }

    private void validateBlob(Blob blob, BlobAttributes blobAttributes, BlobId blobId) {
        if (blob == null) {
            throw new ReplicationIngestionException(String.format("Can't ingest blob %s, the blob doesn't exist", blobId.asUniqueString()));
        }
        if (blobAttributes == null) {
            throw new ReplicationIngestionException(String.format("Can't ingest blob %s, the blob doesn't have related attributes", blobId.asUniqueString()));
        }
    }

    protected void unflattenAttributes(Map<String, Object> backing, String root, String[] children, Object value) {
        if (children.length > 1) {
            if (backing.containsKey(root)) {
                this.unflattenAttributes((Map)backing.get(root), children[0], Arrays.copyOfRange(children, 1, children.length), value);
            } else {
                HashMap<String, Object> rootMap = new HashMap<String, Object>();
                backing.put(root, rootMap);
                this.unflattenAttributes(rootMap, children[0], Arrays.copyOfRange(children, 1, children.length), value);
            }
        } else if (backing.containsKey(root)) {
            ((Map)backing.get(root)).put(children[0], value);
        } else {
            HashMap<String, Object> newEntry = new HashMap<String, Object>();
            newEntry.put(children[0], value);
            backing.put(root, newEntry);
        }
    }

    protected Object convertAttributeValue(String key, String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("{dateepochmillis}")) {
            return new Date(Long.parseLong(value.substring("{dateepochmillis}".length())));
        }
        if (value.startsWith("{jodadatetimeepochmillis}")) {
            return new DateTime(Long.parseLong(value.substring("{jodadatetimeepochmillis}".length())));
        }
        if (value.startsWith("{datetimeepochmillis}")) {
            return new Date(Long.parseLong(value.substring("{datetimeepochmillis}".length()))).toInstant().atOffset(ZoneOffset.UTC);
        }
        return value;
    }
}

