/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.query;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class QueryOptions {
    private static final List<String> SORT_PROPERTIES = Arrays.asList("name", "group", "version", "id");
    private static final List<String> SORT_DIRECTIONS = Arrays.asList("asc", "desc");
    private final String filter;
    private final String sortProperty;
    private final String sortDirection;
    private final Integer start;
    private final Integer limit;
    private final String lastId;
    private final boolean contentAuth;

    public QueryOptions(@Nullable String filter, @Nullable String sortProperty, @Nullable String sortDirection, @Nullable Integer start, @Nullable Integer limit) {
        this(filter, sortProperty, sortDirection, start, limit, null, true);
    }

    public QueryOptions(@Nullable String filter, @Nullable String sortProperty, @Nullable String sortDirection, @Nullable Integer start, @Nullable Integer limit, @Nullable String lastId) {
        this(filter, sortProperty, sortDirection, start, limit, lastId, true);
    }

    public QueryOptions(@Nullable String filter, @Nullable String sortProperty, @Nullable String sortDirection, @Nullable Integer start, @Nullable Integer limit, @Nullable String lastId, boolean contentAuth) {
        this.lastId = lastId;
        Preconditions.checkArgument((sortProperty == null || SORT_PROPERTIES.contains(sortProperty.toLowerCase(Locale.ENGLISH)) ? 1 : 0) != 0);
        Preconditions.checkArgument((sortDirection == null || SORT_DIRECTIONS.contains(sortDirection.toLowerCase(Locale.ENGLISH)) ? 1 : 0) != 0);
        this.filter = filter;
        this.sortProperty = sortProperty;
        this.sortDirection = sortDirection;
        this.start = start;
        this.limit = limit;
        this.contentAuth = contentAuth;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Nullable
    public String getSortProperty() {
        return this.sortProperty;
    }

    @Nullable
    public String getSortDirection() {
        return this.sortDirection;
    }

    @Nullable
    public Integer getStart() {
        return this.start;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public String getLastId() {
        return this.lastId;
    }

    public boolean getContentAuth() {
        return this.contentAuth;
    }
}

