/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.proxy;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.CooperationException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.httpclient.RemoteBlockedIOException;
import org.sonatype.nexus.repository.proxy.BypassHttpErrorException;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.proxy.ProxyServiceException;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

public class ProxyHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response = this.buildMethodNotAllowedResponse(context);
        if (response != null) {
            return response;
        }
        try {
            Content payload = this.proxyFacet(context).get(context);
            if (payload != null) {
                return this.buildPayloadResponse(context, (Payload)payload);
            }
            return this.buildNotFoundResponse(context);
        }
        catch (BypassHttpErrorException e) {
            return this.buildHttpErrorResponce(e);
        }
        catch (ProxyServiceException proxyServiceException) {
            return HttpResponses.serviceUnavailable();
        }
        catch (CooperationException e) {
            return HttpResponses.serviceUnavailable((String)e.getMessage());
        }
        catch (RemoteBlockedIOException e) {
            return HttpResponses.notFound((String)e.getMessage());
        }
        catch (IOException | UncheckedIOException exception) {
            return HttpResponses.badGateway();
        }
    }

    @Nullable
    protected Response buildMethodNotAllowedResponse(Context context) {
        String action = context.getRequest().getAction();
        if (!"GET".equals(action) && !"HEAD".equals(action)) {
            return HttpResponses.methodNotAllowed((String)action, (String[])new String[]{"GET", "HEAD"});
        }
        return null;
    }

    protected Response buildPayloadResponse(Context context, Payload payload) {
        return HttpResponses.ok((Payload)payload);
    }

    protected Response buildNotFoundResponse(Context context) {
        return HttpResponses.notFound();
    }

    protected Response buildHttpErrorResponce(BypassHttpErrorException proxyErrorsException) {
        return new Response.Builder().status(new Status(false, proxyErrorsException.getStatusCode(), proxyErrorsException.getReason())).headers(new Headers(proxyErrorsException.getHeaders())).build();
    }

    private ProxyFacet proxyFacet(Context context) {
        return (ProxyFacet)context.getRepository().facet(ProxyFacet.class);
    }
}

