/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventConsumer;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.distributed.event.service.api.DistributedEvent;
import org.sonatype.nexus.distributed.event.service.api.EventType;
import org.sonatype.nexus.distributed.event.service.api.common.PublisherEvent;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryRemoteConnectionStatusEvent;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationCreatedEvent;
import org.sonatype.nexus.repository.config.ConfigurationDeletedEvent;
import org.sonatype.nexus.repository.config.ConfigurationEvent;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.repository.config.ConfigurationUpdatedEvent;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatus;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusType;
import org.sonatype.nexus.repository.manager.ConfigurationValidator;
import org.sonatype.nexus.repository.manager.DefaultRepositoriesContributor;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryLoadedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.manager.RepositoryRestoredEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.manager.internal.GroupMemberMappingCache;
import org.sonatype.nexus.repository.manager.internal.RepositoryAdminSecurityContributor;
import org.sonatype.nexus.repository.manager.internal.RepositoryFactory;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.validation.ConstraintViolations;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@ManagedObject(domain="org.sonatype.nexus.repository.manager", typeClass=RepositoryManager.class, description="Repository manager")
public class RepositoryManagerImpl
extends StateGuardLifecycleSupport
implements RepositoryManager,
EventAware {
    public static final String CLEANUP_ATTRIBUTES_KEY = "cleanup";
    public static final String CLEANUP_NAME_KEY = "policyName";
    private final FreezeService freezeService;
    private final EventManager eventManager;
    private final ConfigurationStore store;
    private final Map<String, Recipe> recipes;
    private final RepositoryFactory factory;
    private final Provider<ConfigurationFacet> configFacet;
    private final RepositoryAdminSecurityContributor securityContributor;
    private final List<DefaultRepositoriesContributor> defaultRepositoriesContributors;
    private final Map<String, Repository> repositories = Maps.newConcurrentMap();
    private final boolean skipDefaultRepositories;
    private final BlobStoreManager blobStoreManager;
    private final GroupMemberMappingCache groupMemberMappingCache;
    private final List<ConfigurationValidator> configurationValidators;

    @Inject
    public RepositoryManagerImpl(EventManager eventManager, ConfigurationStore store, RepositoryFactory factory, Provider<ConfigurationFacet> configFacet, Map<String, Recipe> recipes, RepositoryAdminSecurityContributor securityContributor, List<DefaultRepositoriesContributor> defaultRepositoriesContributors, FreezeService freezeService, @Named(value="${nexus.skipDefaultRepositories:-false}") boolean skipDefaultRepositories, BlobStoreManager blobStoreManager, GroupMemberMappingCache groupMemberMappingCache, List<ConfigurationValidator> configurationValidators) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.store = (ConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.factory = (RepositoryFactory)Preconditions.checkNotNull((Object)factory);
        this.configFacet = (Provider)Preconditions.checkNotNull(configFacet);
        this.recipes = (Map)Preconditions.checkNotNull(recipes);
        this.securityContributor = (RepositoryAdminSecurityContributor)((Object)Preconditions.checkNotNull((Object)((Object)securityContributor)));
        this.defaultRepositoriesContributors = (List)Preconditions.checkNotNull(defaultRepositoriesContributors);
        this.freezeService = (FreezeService)Preconditions.checkNotNull((Object)freezeService);
        this.skipDefaultRepositories = skipDefaultRepositories;
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.groupMemberMappingCache = (GroupMemberMappingCache)((Object)Preconditions.checkNotNull((Object)((Object)groupMemberMappingCache)));
        this.configurationValidators = (List)Preconditions.checkNotNull(configurationValidators);
    }

    private Recipe recipe(String name) {
        Recipe recipe = this.recipes.get(name);
        Preconditions.checkState((recipe != null ? 1 : 0) != 0, (String)"Missing recipe: %s", (Object)name);
        return recipe;
    }

    private Repository repository(String name) {
        Repository repository = this.repositories.get(name.toLowerCase());
        Preconditions.checkState((repository != null ? 1 : 0) != 0, (String)"Missing repository: %s", (Object)name);
        return repository;
    }

    private Repository newRepository(Configuration configuration) throws Exception {
        String recipeName = configuration.getRecipeName();
        Recipe recipe = this.recipe(recipeName);
        this.log.debug("Using recipe: [{}] {}", (Object)recipeName, (Object)recipe);
        Repository repository = this.factory.create(recipe.getType(), recipe.getFormat());
        repository.attach((Facet)this.configFacet.get());
        recipe.apply(repository);
        repository.facet(ViewFacet.class);
        repository.validate(configuration);
        repository.init(configuration);
        return repository;
    }

    private void track(Repository repository) {
        this.securityContributor.add(repository);
        this.log.debug("Tracking: {}", (Object)repository);
        this.repositories.put(repository.getName().toLowerCase(), repository);
    }

    private void untrack(Repository repository) {
        this.log.debug("Untracking: {}", (Object)repository);
        this.repositories.remove(repository.getName().toLowerCase());
        this.securityContributor.remove(repository);
    }

    protected void doStart() throws Exception {
        this.blobStoreManager.start();
        this.groupMemberMappingCache.init(this);
        List configurations = this.store.list();
        if (configurations.isEmpty()) {
            if (this.skipDefaultRepositories || !this.blobStoreManager.exists("default")) {
                this.log.debug("Skipping provisioning of default repositories");
                return;
            }
            this.log.debug("No repositories configured; provisioning default repositories");
            this.provisionDefaultRepositories();
            configurations = this.store.list();
            if (configurations.isEmpty()) {
                this.log.debug("No default repositories to provision");
                return;
            }
        }
        this.restoreRepositories(configurations);
        this.startRepositories();
    }

    private void provisionDefaultRepositories() {
        for (DefaultRepositoriesContributor contributor : this.defaultRepositoriesContributors) {
            for (Configuration configuration : contributor.getRepositoryConfigurations()) {
                this.log.debug("Provisioning default repository: {}", (Object)configuration);
                this.store.create(configuration);
            }
        }
    }

    private void restoreRepositories(List<Configuration> configurations) throws Exception {
        this.log.debug("Restoring {} repositories", (Object)configurations.size());
        for (Configuration configuration : configurations) {
            this.log.debug("Restoring repository: {}", (Object)configuration);
            Repository repository = this.newRepository(configuration);
            this.track(repository);
            this.eventManager.post((Object)new RepositoryLoadedEvent(repository));
        }
    }

    private void startRepositories() throws Exception {
        this.log.debug("Starting {} repositories", (Object)this.repositories.size());
        for (Repository repository : this.repositories.values()) {
            this.log.debug("Starting repository: {}", (Object)repository);
            repository.start();
            this.eventManager.post((Object)new RepositoryRestoredEvent(repository));
        }
    }

    protected void doStop() throws Exception {
        this.log.debug("Stopping {} repositories", (Object)this.repositories.size());
        for (Repository repository : this.repositories.values()) {
            this.log.debug("Stopping repository: {}", (Object)repository);
            repository.stop();
        }
        this.log.debug("Destroying {} repositories", (Object)this.repositories.size());
        for (Repository repository : this.repositories.values()) {
            this.log.debug("Destroying repository: {}", (Object)repository);
            repository.destroy();
        }
        this.repositories.clear();
        this.blobStoreManager.stop();
    }

    @Guarded(by={"STARTED"})
    public Iterable<Repository> browse() {
        return ImmutableList.copyOf(this.repositories.values());
    }

    @Guarded(by={"STARTED"})
    public Iterable<Repository> browseForBlobStore(String blobStoreId) {
        Iterable<Repository> browseResult = this.browse();
        if (browseResult != null && browseResult.iterator().hasNext()) {
            return StreamSupport.stream(browseResult.spliterator(), true).filter(Repository::isStarted).filter(r -> blobStoreId.equals(r.getConfiguration().attributes("storage").get("blobStoreName")))::iterator;
        }
        return Collections.emptyList();
    }

    public boolean exists(String name) {
        return this.isRepositoryLoaded(name) || this.store.exists(name);
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public Repository get(String name) {
        Preconditions.checkNotNull((Object)name);
        Repository repository = this.repositories.get(name.toLowerCase());
        if (repository == null) {
            Collection configurations = this.store.readByNames(Collections.singleton(name));
            if (configurations.isEmpty()) {
                return null;
            }
            try {
                return this.loadRepositoryIntoMemory((Configuration)configurations.stream().findFirst().get());
            }
            catch (Exception e) {
                this.log.error("Exception loading repository: {} into memory", (Object)name, (Object)e);
                return null;
            }
        }
        return repository;
    }

    @Guarded(by={"STARTED"})
    public Repository create(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        this.validateConfiguration(configuration);
        Repository repository = this.loadRepositoryIntoMemory(configuration);
        if (!EventHelper.isReplicating()) {
            this.store.create(configuration);
        }
        repository.start();
        this.eventManager.post((Object)new RepositoryCreatedEvent(repository));
        this.distributeRepositoryConfigurationEvent(repository.getName(), EventType.CREATED);
        return repository;
    }

    @Guarded(by={"STARTED"})
    public Repository update(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        this.validateConfiguration(configuration);
        Configuration oldConfiguration = this.repository(configuration.getRepositoryName()).getConfiguration().copy();
        String repositoryName = (String)Preconditions.checkNotNull((Object)configuration.getRepositoryName());
        this.validateRepositoryConfiguration(repositoryName, configuration);
        if (!EventHelper.isReplicating()) {
            this.store.update(configuration);
        }
        Repository repository = this.updateRepositoryInMemory(configuration);
        this.eventManager.post((Object)new RepositoryUpdatedEvent(repository, oldConfiguration));
        this.distributeRepositoryConfigurationEvent(repository.getName(), EventType.UPDATED);
        return repository;
    }

    @Guarded(by={"STARTED"})
    public void delete(String name) throws Exception {
        Preconditions.checkNotNull((Object)name);
        Repository repository = this.deleteRepositoryFromMemory(name);
        if (!EventHelper.isReplicating()) {
            Optional<Configuration> configuration = this.repositoryConfiguration(name);
            configuration.ifPresent(arg_0 -> ((ConfigurationStore)this.store).delete(arg_0));
        }
        this.eventManager.post((Object)new RepositoryDeletedEvent(repository));
        this.distributeRepositoryConfigurationEvent(name, EventType.DELETED);
        this.log.info("Deleted repository: {}", (Object)name);
    }

    private Repository deleteRepositoryFromMemory(String name) throws Exception {
        Preconditions.checkNotNull((Object)name);
        this.freezeService.checkWritable("Unable to delete repository when database is frozen.");
        this.log.info("Deleting repository from memory: {}", (Object)name);
        Repository repository = this.repository(name);
        this.removeRepositoryFromAllGroups(repository);
        repository.stop();
        repository.delete();
        repository.destroy();
        this.untrack(repository);
        return repository;
    }

    private Repository loadRepositoryIntoMemory(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        String repositoryName = (String)Preconditions.checkNotNull((Object)configuration.getRepositoryName());
        this.log.info("Creating repository in memory: {} -> {}", (Object)repositoryName, (Object)configuration);
        this.validateConfiguration(configuration);
        Repository repository = this.newRepository(configuration);
        this.track(repository);
        return repository;
    }

    private Repository updateRepositoryInMemory(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        String repositoryName = (String)Preconditions.checkNotNull((Object)configuration.getRepositoryName());
        this.log.info("Updating repository in memory: {} -> {}", (Object)repositoryName, (Object)configuration);
        Repository repository = this.repository(repositoryName);
        repository.stop();
        repository.update(configuration);
        repository.start();
        return repository;
    }

    @Guarded(by={"STARTED"})
    public List<String> findContainingGroups(String repositoryName) {
        return this.groupMemberMappingCache.getGroups(repositoryName);
    }

    private void removeRepositoryFromAllGroups(Repository repositoryToRemove) throws Exception {
        for (Repository group : this.repositories.values()) {
            Optional groupFacet = group.optionalFacet(GroupFacet.class);
            if (!groupFacet.isPresent() || !((GroupFacet)groupFacet.get()).member(repositoryToRemove)) continue;
            this.removeRepositoryFromGroup(repositoryToRemove, group);
        }
    }

    private void removeRepositoryFromGroup(Repository repositoryToRemove, Repository group) throws Exception {
        Configuration configuration = group.getConfiguration().copy();
        NestedAttributesMap groupAttributes = configuration.attributes("group");
        ((Collection)groupAttributes.get("memberNames", Collection.class)).remove(repositoryToRemove.getName());
        this.update(configuration);
    }

    private Stream<Object> blobstoreUsageStream(String blobStoreName) {
        return StreamSupport.stream(this.browse().spliterator(), false).map(Repository::getConfiguration).map(Configuration::getAttributes).map(a -> (Map)a.get("storage")).map(s -> s.get("blobStoreName")).filter(blobStoreName::equals);
    }

    public boolean isBlobstoreUsed(String blobStoreName) {
        return this.blobstoreUsageStream(blobStoreName).findAny().isPresent() || this.blobStoreManager.blobStoreUsageCount(blobStoreName) > 0L;
    }

    public boolean isDataStoreUsed(String dataStoreName) {
        return StreamSupport.stream(this.browse().spliterator(), false).map(Repository::getConfiguration).map(Configuration::getAttributes).map(a -> (Map)a.get("storage")).map(s -> s.get("dataStoreName")).anyMatch(dataStoreName::equals);
    }

    public long blobstoreUsageCount(String blobStoreName) {
        return this.blobstoreUsageStream(blobStoreName).count();
    }

    public Stream<Repository> browseForCleanupPolicy(String cleanupPolicyName) {
        return StreamSupport.stream(this.browse().spliterator(), false).filter(repository -> this.repositoryHasCleanupPolicy((Repository)repository, cleanupPolicyName));
    }

    public Collection<Recipe> getAllSupportedRecipes() {
        return this.recipes.values();
    }

    public Configuration newConfiguration() {
        return this.store.newConfiguration();
    }

    @Subscribe
    public void on(RepositoryConfigurationEvent event) {
        String repositoryName = event.getRepositoryName();
        EventType eventType = event.getEventType();
        this.log.debug("Consume distributed RepositoryConfigurationEvent: repository={}, type={}", (Object)repositoryName, (Object)eventType);
        switch (eventType) {
            case CREATED: {
                this.handleRepositoryCreated(repositoryName);
                break;
            }
            case UPDATED: {
                this.handleRepositoryUpdated(repositoryName);
                break;
            }
            case DELETED: {
                this.handleRepositoryDeleted(repositoryName);
                break;
            }
            default: {
                this.log.error("Unknown event type {}", (Object)eventType);
            }
        }
    }

    @Subscribe
    public void on(RepositoryRemoteConnectionStatusEvent event) {
        String repositoryName = event.getRepositoryName();
        RemoteConnectionStatusType statusType = RemoteConnectionStatusType.values()[event.getRemoteConnectionStatusTypeOrdinal()];
        this.log.warn("Consume distributed RepositoryRemoteConnectionStatusEvent: repository={}, type={}", (Object)repositoryName, (Object)statusType);
        RemoteConnectionStatus status = new RemoteConnectionStatus(statusType, event.getReason()).setBlockedUntil(new DateTime(event.getBlockedUntilMillis())).setRequestUrl(event.getRequestUrl());
        ((HttpClientFacet)this.repository(repositoryName).facet(HttpClientFacet.class)).setStatus(status);
    }

    @Subscribe
    public void on(ConfigurationCreatedEvent event) {
        this.handleReplication((ConfigurationEvent)event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> {
            Repository repository = this.create(e.getConfiguration());
        }));
    }

    @Subscribe
    public void on(ConfigurationUpdatedEvent event) {
        this.handleReplication((ConfigurationEvent)event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> {
            Repository repository = this.update(e.getConfiguration());
        }));
    }

    @Subscribe
    public void on(ConfigurationDeletedEvent event) {
        this.handleReplication((ConfigurationEvent)event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> this.delete(e.getRepositoryName())));
    }

    private void handleReplication(ConfigurationEvent event, EventConsumer<ConfigurationEvent> consumer) {
        if (!event.isLocal()) {
            try {
                consumer.accept((Object)event);
            }
            catch (Exception e) {
                this.log.error("Failed to replicate: {}", (Object)event, (Object)e);
            }
        }
    }

    private boolean repositoryHasCleanupPolicy(Repository repository, String cleanupPolicyName) {
        return Optional.ofNullable(repository.getConfiguration()).map(Configuration::getAttributes).map(attributes -> (Map)attributes.get(CLEANUP_ATTRIBUTES_KEY)).filter(Objects::nonNull).map(cleanupPolicyMap -> (Collection)cleanupPolicyMap.get(CLEANUP_NAME_KEY)).filter(Objects::nonNull).filter(cleanupPolicies -> cleanupPolicies.contains(cleanupPolicyName)).isPresent();
    }

    private void validateConfiguration(Configuration configuration) {
        HashSet violations = new HashSet();
        this.configurationValidators.forEach(validator -> ConstraintViolations.maybeAdd((Set)violations, (ConstraintViolation[])new ConstraintViolation[]{validator.validate(configuration)}));
        ConstraintViolations.maybePropagate(violations, (Logger)this.log);
    }

    private Optional<Configuration> repositoryConfiguration(String repositoryName) {
        Preconditions.checkNotNull((Object)repositoryName);
        List configurations = this.store.list();
        if (!configurations.isEmpty()) {
            return configurations.stream().filter(config -> config.getRepositoryName().equals(repositoryName)).findFirst();
        }
        return Optional.empty();
    }

    private void handleRepositoryCreated(String repositoryName) {
        if (this.isRepositoryLoaded(repositoryName)) {
            return;
        }
        Optional<Configuration> configuration = this.repositoryConfiguration(repositoryName);
        configuration.ifPresent(config -> {
            try {
                Repository repository = this.loadRepositoryIntoMemory((Configuration)config);
                repository.start();
                this.eventManager.post((Object)new RepositoryCreatedEvent(repository));
            }
            catch (Exception e) {
                this.log.error("Error updating repository on the current node UI.", (Throwable)e);
            }
        });
    }

    private void handleRepositoryUpdated(String repositoryName) {
        if (!this.isRepositoryLoaded(repositoryName)) {
            this.log.debug("Can not find repository configuration {}", (Object)repositoryName);
            return;
        }
        Optional<Configuration> configuration = this.repositoryConfiguration(repositoryName);
        configuration.ifPresent(config -> {
            try {
                this.validateConfiguration((Configuration)config);
                Configuration oldConfiguration = this.repository(repositoryName).getConfiguration().copy();
                Repository repository = this.repository(repositoryName);
                this.updateRepositoryInMemory((Configuration)config);
                this.eventManager.post((Object)new RepositoryUpdatedEvent(repository, oldConfiguration));
            }
            catch (Exception e) {
                this.log.error("Error updating repository configuration on UI", (Throwable)e);
            }
        });
    }

    private void handleRepositoryDeleted(String repositoryName) {
        if (!this.isRepositoryLoaded(repositoryName)) {
            this.log.debug("Repository {} already deleted on the current node", (Object)repositoryName);
            return;
        }
        try {
            Repository repository = this.deleteRepositoryFromMemory(repositoryName);
            this.eventManager.post((Object)new RepositoryDeletedEvent(repository));
        }
        catch (Exception e) {
            this.log.error("Error deleting repository on the current node.", (Throwable)e);
        }
    }

    private void distributeRepositoryConfigurationEvent(String repositoryName, EventType eventType) {
        this.log.debug("Distribute repository configuration event: repository={}:{}", (Object)repositoryName, (Object)eventType);
        RepositoryConfigurationEvent configEvent = new RepositoryConfigurationEvent(repositoryName, eventType);
        this.eventManager.post((Object)new PublisherEvent((DistributedEvent)configEvent));
    }

    private void validateRepositoryConfiguration(String repositoryName, Configuration configuration) throws Exception {
        Repository repository = this.repository(repositoryName);
        repository.validate(configuration);
    }

    private boolean isRepositoryLoaded(String repositoryName) {
        return this.repositories.containsKey(repositoryName.toLowerCase());
    }
}

