/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;

@Singleton
@Named
public class GroupMemberMappingCache
extends ComponentSupport
implements EventAware {
    private volatile Map<String, List<String>> memberInGroupsMap;
    private RepositoryManager repositoryManager;

    @Subscribe
    public void on(RepositoryCreatedEvent event) {
        this.log.debug("Handling repository create event for {}", (Object)event.getRepository().getName());
        if (event.getRepository().optionalFacet(GroupFacet.class).isPresent()) {
            this.memberInGroupsMap = null;
        }
    }

    @Subscribe
    public void on(RepositoryUpdatedEvent event) {
        this.log.debug("Handling repository updated event for {}", (Object)event.getRepository().getName());
        if (event.getRepository().optionalFacet(GroupFacet.class).isPresent()) {
            this.memberInGroupsMap = null;
        }
    }

    @Subscribe
    public void on(RepositoryDeletedEvent event) {
        this.log.debug("Handling repository deleted event for {}", (Object)event.getRepository().getName());
        this.memberInGroupsMap = null;
    }

    List<String> getGroups(String member) {
        return new ArrayList<String>(this.getCache().getOrDefault(member, Collections.emptyList()));
    }

    void init(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getCache() {
        Map<String, List<String>> cache = this.memberInGroupsMap;
        if (cache == null) {
            GroupMemberMappingCache groupMemberMappingCache = this;
            synchronized (groupMemberMappingCache) {
                if (this.memberInGroupsMap == null) {
                    this.memberInGroupsMap = this.populateCache();
                }
                cache = this.memberInGroupsMap;
            }
        }
        return cache;
    }

    private Map<String, List<String>> populateCache() {
        HashMap<String, List<String>> cache = new HashMap<String, List<String>>();
        this.repositoryManager.browse().forEach(repository -> {
            if (!repository.optionalFacet(GroupFacet.class).isPresent()) {
                TreeMap<Integer, List<String>> groupNamesByLevel = new TreeMap<Integer, List<String>>();
                this.findContainingGroups(repository.getName(), groupNamesByLevel, 0);
                cache.put(repository.getName(), groupNamesByLevel.values().stream().peek(groupNames -> groupNames.sort(null)).flatMap(Collection::stream).collect(Collectors.toList()));
            }
        });
        return cache;
    }

    private void findContainingGroups(String name, SortedMap<Integer, List<String>> groupNamesByLevel, int level) {
        ArrayList newContainingGroups = new ArrayList();
        this.repositoryManager.browse().forEach(repository -> repository.optionalFacet(GroupFacet.class).ifPresent(groupFacet -> {
            String groupName = repository.getName();
            if (groupFacet.member(name) && groupNamesByLevel.values().stream().noneMatch(groupNames -> groupNames.contains(groupName))) {
                newContainingGroups.add(groupName);
            }
        }));
        List groupNames = groupNamesByLevel.computeIfAbsent(level, newLevel -> new ArrayList());
        groupNames.addAll(newContainingGroups);
        newContainingGroups.forEach(newName -> this.findContainingGroups((String)newName, groupNamesByLevel, level + 1));
    }
}

