/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.json.NestedAttributesMapJsonParser;

public class NestedAttributesMapUntypedObjectDeserializer
extends UntypedObjectDeserializer {
    private NestedAttributesMapJsonParser jsonParser;

    public NestedAttributesMapUntypedObjectDeserializer(NestedAttributesMapJsonParser jsonParser) {
        super(null, null);
        this.jsonParser = (NestedAttributesMapJsonParser)((Object)Preconditions.checkNotNull((Object)((Object)jsonParser)));
    }

    protected Object mapArray(JsonParser parser, DeserializationContext context) throws IOException {
        try {
            this.markMappingInsideArray();
            Object object = super.mapArray(parser, context);
            return object;
        }
        finally {
            this.unMarkMappingInsideArray();
        }
    }

    protected NestedAttributesMap getChildFromRoot() {
        return this.jsonParser.getChildFromRoot();
    }

    protected boolean isMappingInsideArray() {
        return this.jsonParser.isMappingInsideArray();
    }

    protected String currentPath() {
        return this.jsonParser.currentPath();
    }

    protected boolean isMappingField(String name) {
        return this.jsonParser.currentPath().endsWith(name);
    }

    protected void markMappingInsideArray() {
        this.jsonParser.markMappingInsideArray();
    }

    protected void unMarkMappingInsideArray() {
        this.jsonParser.unMarkMappingInsideArray();
    }

    protected boolean isDefaultMapping() {
        return this.jsonParser.isDefaultMapping();
    }

    protected void enableDefaultMapping() {
        this.jsonParser.enableDefaultMapping();
    }

    protected void disableDefaultMapping() {
        this.jsonParser.disableDefaultMapping();
    }
}

