/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonStreamContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.json.JsonParserDecorator;

public class CurrentPathJsonParser
extends JsonParserDecorator {
    private static final String JSON_PATH_SEPARATOR = "/";

    public CurrentPathJsonParser(JsonParser jsonParser) {
        super(jsonParser);
    }

    public String currentPath() {
        return this.currentPath(this.currentPointer());
    }

    public String[] currentPathInParts() {
        String currentPath = this.currentPath().substring(1);
        return StringUtils.isBlank((CharSequence)currentPath) ? ArrayUtils.EMPTY_STRING_ARRAY : currentPath.split(JSON_PATH_SEPARATOR);
    }

    public JsonPointer currentPointer() {
        return JsonPointer.forPath((JsonStreamContext)this.getParsingContext(), (boolean)false);
    }

    private String currentPath(JsonPointer pointer) {
        return this.toValidPath(pointer.toString());
    }

    private String toValidPath(String path) {
        return StringUtils.isBlank((CharSequence)path) ? JSON_PATH_SEPARATOR : path;
    }
}

