/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.search.index.task;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.index.SearchIndexFacet;
import org.sonatype.nexus.repository.search.index.SearchUpdateService;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class SearchUpdateTask
extends TaskSupport
implements Cancelable {
    private final RepositoryManager repositoryManager;
    private final SearchUpdateService searchUpdateService;

    @Inject
    public SearchUpdateTask(RepositoryManager repositoryManager, SearchUpdateService searchUpdateService) {
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.searchUpdateService = Objects.requireNonNull(searchUpdateService);
    }

    protected Object execute() {
        String[] repositoryNames;
        String[] stringArray = repositoryNames = this.getRepositoryNamesField();
        int n = repositoryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Repository repository = this.repositoryManager.get(name);
            if (repository != null) {
                this.log.info("Updating search index for repo {}", (Object)name);
                SearchIndexFacet searchIndexFacet = (SearchIndexFacet)repository.facet(SearchIndexFacet.class);
                searchIndexFacet.rebuildIndex();
                this.searchUpdateService.doneReindexing(repository);
                this.log.info("Completed update of search index for repo {}", (Object)name);
            }
            ++n2;
        }
        return null;
    }

    public String getMessage() {
        return "Updating search indexes of " + String.join((CharSequence)",", this.getRepositoryNamesField());
    }

    private String[] getRepositoryNamesField() {
        String value = this.getConfiguration().getString("repositoryNames");
        if (value != null) {
            return value.split(",");
        }
        return new String[0];
    }
}

