/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.group;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named
@Singleton
public class GroupHandler
extends ComponentSupport
implements Handler {
    public static final String IGNORE_FIREWALL = "IGNORE_FIREWALL";
    public static final String USE_DISPATCHED_RESPONSE = "USE_DISPATCHED_RESPONSE";
    public static final String INSUFFICIENT_LICENSE = "Deploying to groups is a PRO-licensed feature. See https://links.sonatype.com/product-nexus-repository";

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String method;
        switch (method = context.getRequest().getAction()) {
            case "GET": 
            case "HEAD": {
                DispatchedRepositories dispatched = (DispatchedRepositories)context.getRequest().getAttributes().getOrCreate(DispatchedRepositories.class);
                return this.doGet(context, dispatched);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD"});
    }

    protected Response doGet(@Nonnull Context context, @Nonnull DispatchedRepositories dispatched) throws Exception {
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        return this.getFirst(context, groupFacet.members(), dispatched);
    }

    protected Response getFirst(@Nonnull Context context, @Nonnull List<Repository> members, @Nonnull DispatchedRepositories dispatched) throws Exception {
        Request request = context.getRequest();
        for (Repository member : members) {
            this.log.trace("Trying member: {}", (Object)member);
            if (dispatched.contains(member)) {
                this.log.trace("Skipping already dispatched member: {}", (Object)member);
                continue;
            }
            dispatched.add(member);
            ViewFacet view = (ViewFacet)member.facet(ViewFacet.class);
            Response response = view.dispatch(request, context);
            this.log.trace("Member {} response {}", (Object)member, (Object)response.getStatus());
            if (!this.isValidResponse(response)) continue;
            return response;
        }
        return this.notFoundResponse(context);
    }

    protected LinkedHashMap<Repository, Response> getAll(@Nonnull Context context, @Nonnull Iterable<Repository> members, @Nonnull DispatchedRepositories dispatched) throws Exception {
        return this.getAll(context.getRequest(), context, members, dispatched);
    }

    protected LinkedHashMap<Repository, Response> getAll(@Nonnull Request request, @Nonnull Context context, @Nonnull Iterable<Repository> members, @Nonnull DispatchedRepositories dispatched) throws Exception {
        LinkedHashMap responses = Maps.newLinkedHashMap();
        for (Repository member : members) {
            this.log.trace("Trying member: {}", (Object)member);
            if (dispatched.contains(member)) {
                this.log.trace("Skipping already dispatched member: {}", (Object)member);
                continue;
            }
            dispatched.add(member);
            ViewFacet view = (ViewFacet)member.facet(ViewFacet.class);
            Response response = view.dispatch(request, context);
            this.log.trace("Member {} response {}", (Object)member, (Object)response.getStatus());
            responses.put(member, response);
        }
        return responses;
    }

    protected Response notFoundResponse(Context context) {
        return HttpResponses.notFound();
    }

    private boolean isValidResponse(Response response) {
        return response.getStatus().isSuccessful() || response.getAttributes().contains(USE_DISPATCHED_RESPONSE) || "true".equals(response.getHeaders().get("BYPASS_HTTP_ERRORS"));
    }

    @VisibleForTesting
    public static class DispatchedRepositories {
        private final Set<String> dispatched = Sets.newLinkedHashSet();

        public void add(Repository repository) {
            this.dispatched.add(repository.getName());
        }

        public boolean contains(Repository repository) {
            return this.dispatched.contains(repository.getName());
        }

        public String toString() {
            return this.dispatched.toString();
        }

        public Set<String> getDispatched() {
            return Collections.unmodifiableSet(this.dispatched);
        }
    }
}

