/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.group;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.validation.ConstraintViolationFactory;
import org.sonatype.nexus.validation.ConstraintViolations;

@Named(value="default")
public class GroupFacetImpl
extends FacetSupport
implements GroupFacet {
    private final RepositoryManager repositoryManager;
    private final Type groupType;
    private final ConstraintViolationFactory constraintViolationFactory;
    public static final String CONFIG_KEY = "group";
    private final RepositoryCacheInvalidationService repositoryCacheInvalidationService;
    private Config config;
    protected CacheController cacheController;

    @Inject
    public GroupFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType);
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.repositoryCacheInvalidationService = (RepositoryCacheInvalidationService)Preconditions.checkNotNull((Object)repositoryCacheInvalidationService);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
        if (this.getStateGuard().is("STARTED")) {
            Config configToValidate = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
            HashSet violations = new HashSet();
            ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validateGroupDoesNotContainItself(configuration.getRepositoryName(), configToValidate)});
            ConstraintViolations.maybePropagate(violations, (Logger)this.log);
        }
    }

    private boolean containsGroup(Repository root, String repositoryName, Set<Repository> checkedGroups) {
        return ((GroupFacet)root.facet(GroupFacet.class)).members().stream().anyMatch(repository -> checkedGroups.add((Repository)repository) && (repository.getName().equals(repositoryName) || this.groupType.equals((Object)repository.getType()) && this.containsGroup((Repository)repository, repositoryName, checkedGroups)));
    }

    ConstraintViolation<?> validateGroupDoesNotContainItself(String repositoryName, Config config) {
        HashSet<Repository> checkedGroups = new HashSet<Repository>();
        for (String memberName : config.memberNames) {
            Repository repository = this.repositoryManager.get(memberName);
            if (!repository.getName().equals(repositoryName) && (!this.groupType.equals((Object)repository.getType()) || !this.containsGroup(repository, repositoryName, checkedGroups))) continue;
            return this.constraintViolationFactory.createViolation("group.memberNames", "Group '" + repository.getName() + "' has a member repository '" + repositoryName + "' and cannot be added to this list.");
        }
        return null;
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.cacheController = new CacheController(-1, null);
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected void doUpdate(Configuration configuration) throws Exception {
        Set<String> previousMemberNames = this.config.memberNames;
        super.doUpdate(configuration);
        if (!Iterables.elementsEqual(this.config.memberNames, previousMemberNames)) {
            this.cacheController.invalidateCache();
        }
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean member(String repositoryName) {
        Preconditions.checkNotNull((Object)repositoryName);
        return this.config.memberNames.contains(repositoryName);
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean member(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        return this.config.memberNames.contains(repository.getName());
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Repository> members() {
        Repository repository = this.getRepository();
        ArrayList<Repository> members = new ArrayList<Repository>(this.config.memberNames.size());
        for (String name : this.config.memberNames) {
            Repository member = this.repositoryManager.get(name);
            if (member == null) {
                this.log.warn("Ignoring missing member repository: {}", (Object)name);
                continue;
            }
            if (!repository.getFormat().equals((Object)member.getFormat())) {
                this.log.warn("Group {} includes an incompatible-format member: {} with format {}", new Object[]{repository.getName(), name, member.getFormat()});
                continue;
            }
            members.add(member);
        }
        return members;
    }

    @Override
    public List<Repository> leafMembers() {
        LinkedHashSet<Repository> leafMembers = new LinkedHashSet<Repository>();
        for (Repository repository : this.members()) {
            if (this.groupType.equals((Object)repository.getType())) {
                leafMembers.addAll(((GroupFacet)repository.facet(GroupFacet.class)).leafMembers());
                continue;
            }
            leafMembers.add(repository);
        }
        return new ArrayList<Repository>(leafMembers);
    }

    @Override
    public List<Repository> allMembers() {
        return GroupFacetImpl.allMembers(new ArrayList<Repository>(), this.getRepository());
    }

    private static List<Repository> allMembers(List<Repository> members, Repository root) {
        members.add(root);
        List groupMembers = root.optionalFacet(GroupFacet.class).map(GroupFacet::members).orElseGet(Collections::emptyList);
        for (Repository child : groupMembers) {
            GroupFacetImpl.allMembers(members, child);
        }
        return members;
    }

    @Override
    public void invalidateGroupCaches() {
        this.log.info("Invalidating group caches of {}", (Object)this.getRepository().getName());
        this.cacheController.invalidateCache();
        for (Repository repository : this.members()) {
            this.repositoryCacheInvalidationService.processCachesInvalidation(repository);
        }
    }

    @Override
    public boolean isStale(@Nullable Content content) {
        if (content == null) {
            return true;
        }
        CacheInfo cacheInfo = (CacheInfo)content.getAttributes().get(CacheInfo.class);
        if (Objects.isNull(cacheInfo)) {
            this.log.warn("CacheInfo missing for {}, assuming stale content.", (Object)content);
            return true;
        }
        return this.cacheController.isStale(cacheInfo);
    }

    @Override
    public void maintainCacheInfo(AttributesMap attributesMap) {
        attributesMap.set(CacheInfo.class, (Object)this.cacheController.current());
    }

    public static class Config {
        @NotNull
        @JsonDeserialize(as=LinkedHashSet.class)
        public Set<String> memberNames;

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "memberNames=" + this.memberNames + '}';
        }
    }
}

