/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.capability.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.function.Supplier;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.capability.internal.RepositoryConditionSupport;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;

public class RepositoryExistsCondition
extends RepositoryConditionSupport {
    public RepositoryExistsCondition(EventManager eventManager, RepositoryManager repositoryManager, Supplier<String> repositoryName) {
        super(eventManager, repositoryManager, repositoryName);
    }

    @Override
    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryCreatedEvent event) {
        if (this.sameRepositoryAs(event.getRepository().getName())) {
            this.setSatisfied(true);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryDeletedEvent event) {
        if (this.sameRepositoryAs(event.getRepository().getName())) {
            this.setSatisfied(false);
        }
    }

    public String toString() {
        try {
            String repositoryName = this.getRepositoryName();
            return String.format("Repository '%s' exists", repositoryName);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' exists";
        }
    }

    public String explainSatisfied() {
        try {
            String repositoryName = this.getRepositoryName();
            return String.format("Repository '%s' exists", repositoryName);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' exists";
        }
    }

    public String explainUnsatisfied() {
        try {
            String repositoryName = this.getRepositoryName();
            return String.format("Repository '%s' does not exist", repositoryName);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' does not exist";
        }
    }
}

