/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.capability.internal;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.capability.RepositoryConditions;
import org.sonatype.nexus.repository.capability.internal.RepositoryExistsCondition;
import org.sonatype.nexus.repository.capability.internal.RepositoryOnlineCondition;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class RepositoryConditionsImpl
implements RepositoryConditions {
    private final EventManager eventManager;
    private final RepositoryManager repositoryManager;

    @Inject
    public RepositoryConditionsImpl(EventManager eventManager, RepositoryManager repositoryManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Override
    public Condition repositoryIsOnline(Supplier<String> repositoryName) {
        return new RepositoryOnlineCondition(this.eventManager, this.repositoryManager, repositoryName);
    }

    @Override
    public Condition repositoryExists(Supplier<String> repositoryName) {
        return new RepositoryExistsCondition(this.eventManager, this.repositoryManager, repositoryName);
    }
}

