/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.capability.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityContextAware;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.capability.condition.ConditionSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryLoadedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;

public abstract class RepositoryConditionSupport
extends ConditionSupport
implements CapabilityContextAware {
    private final RepositoryManager repositoryManager;
    private final Supplier<String> repositoryName;
    private final ReentrantReadWriteLock bindLock;
    private CapabilityIdentity capabilityIdentity;
    private String repositoryBeforeLastUpdate;

    public RepositoryConditionSupport(EventManager eventManager, RepositoryManager repositoryManager, Supplier<String> repositoryName) {
        super(eventManager, false);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryName = (Supplier)Preconditions.checkNotNull(repositoryName);
        this.bindLock = new ReentrantReadWriteLock();
    }

    public RepositoryConditionSupport setContext(CapabilityContext context) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot contextualize when already bounded");
        Preconditions.checkState((this.capabilityIdentity == null ? 1 : 0) != 0, (Object)("Already contextualized with id '" + this.capabilityIdentity + "'"));
        this.capabilityIdentity = context.id();
        return this;
    }

    protected void doBind() {
        try {
            this.bindLock.writeLock().lock();
            for (Repository repository : this.repositoryManager.browse()) {
                this.handle(new RepositoryCreatedEvent(repository));
            }
        }
        finally {
            this.bindLock.writeLock().unlock();
        }
        this.getEventManager().register((Object)this);
    }

    public void doRelease() {
        this.getEventManager().unregister((Object)this);
    }

    public abstract void handle(RepositoryCreatedEvent var1);

    protected void setSatisfied(boolean satisfied) {
        try {
            this.bindLock.readLock().lock();
            super.setSatisfied(satisfied);
        }
        finally {
            this.bindLock.readLock().unlock();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryLoadedEvent event) {
        this.handle(new RepositoryCreatedEvent(event.getRepository()));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.BeforeUpdate event) {
        if (event.getReference().context().id().equals((Object)this.capabilityIdentity)) {
            this.repositoryBeforeLastUpdate = this.getRepositoryName();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterUpdate event) {
        if (event.getReference().context().id().equals((Object)this.capabilityIdentity) && !this.sameRepositoryAs(this.repositoryBeforeLastUpdate)) {
            try {
                this.bindLock.writeLock().lock();
                for (Repository repository : this.repositoryManager.browse()) {
                    this.handle(new RepositoryCreatedEvent(repository));
                }
            }
            finally {
                this.bindLock.writeLock().unlock();
            }
        }
    }

    protected boolean sameRepositoryAs(String repositoryName) {
        return repositoryName != null && repositoryName.equals(this.getRepositoryName());
    }

    protected String getRepositoryName() {
        return this.repositoryName.get();
    }
}

