/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.capability;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.repository.capability.GlobalRepositorySettings;
import org.sonatype.nexus.repository.capability.StorageSettingsCapabilityConfiguration;

@Named(value="StorageSettings")
@Singleton
public class StorageSettingsCapabilityDescriptor
extends CapabilityDescriptorSupport<StorageSettingsCapabilityConfiguration>
implements Taggable {
    public static final String TYPE_ID = "StorageSettings";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"StorageSettings");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = ImmutableList.of((Object)new NumberTextFormField("lastDownloadedInterval", messages.assetLabel(), messages.lastDownloadedIntervalLabel(), true).withInitialValue((Number)GlobalRepositorySettings.DEFAULT_LAST_DOWNLOADED_INTERVAL.toHours()).withMinimumValue((Number)1));

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Core")});
    }

    protected StorageSettingsCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new StorageSettingsCapabilityConfiguration(properties);
    }

    protected String renderAbout() throws Exception {
        return this.render("StorageSettings-about.vm");
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Storage Settings")
        public String name();

        @MessageBundle.DefaultMessage(value="Asset:")
        public String assetLabel();

        @MessageBundle.DefaultMessage(value="'Last Downloaded' Update Interval (hours)")
        public String lastDownloadedIntervalLabel();
    }
}

