/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.cache.NegativeCacheKey;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

public class NegativeCacheHandler
extends ComponentSupport
implements Handler {
    private static final Set<String> NFC_CACHEABLE_ACTIONS = ImmutableSet.of((Object)"GET", (Object)"HEAD");

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response;
        NegativeCacheKey key;
        String action = context.getRequest().getAction();
        if (!NFC_CACHEABLE_ACTIONS.contains(action)) {
            return context.proceed();
        }
        NegativeCacheFacet negativeCache = (NegativeCacheFacet)context.getRepository().facet(NegativeCacheFacet.class);
        Status status = negativeCache.get(key = negativeCache.getCacheKey(context));
        if (status == null) {
            response = context.proceed();
            if (this.isNotFound(response)) {
                negativeCache.put(key, response.getStatus());
            } else if (response.getStatus().isSuccessful()) {
                negativeCache.invalidate(key);
            }
        } else {
            response = this.buildResponse(status, context);
            this.log.debug("Found {} in negative cache, returning {}", (Object)key, (Object)response);
        }
        return response;
    }

    protected Response buildResponse(Status status, Context context) {
        return new Response.Builder().status(status).build();
    }

    private boolean isNotFound(Response response) {
        return 404 == response.getStatus().getCode();
    }
}

