/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.AttributesMap;

public class CacheInfo {
    @VisibleForTesting
    public static final String CACHE = "cache";
    @VisibleForTesting
    public static final String CACHE_TOKEN = "cache_token";
    @VisibleForTesting
    public static final String LAST_VERIFIED = "last_verified";
    @VisibleForTesting
    public static final String INVALIDATED = "invalidated";
    private final DateTime lastVerified;
    @Nullable
    private final String cacheToken;

    public CacheInfo(DateTime lastVerified, @Nullable String cacheToken) {
        this.lastVerified = (DateTime)Preconditions.checkNotNull((Object)lastVerified);
        this.cacheToken = cacheToken;
    }

    public DateTime getLastVerified() {
        return this.lastVerified;
    }

    @Nullable
    public String getCacheToken() {
        return this.cacheToken;
    }

    public boolean isInvalidated() {
        return INVALIDATED.equals(this.cacheToken);
    }

    public Map<String, String> toMap() {
        ImmutableMap.Builder cacheHeaders = ImmutableMap.builder();
        cacheHeaders.put((Object)LAST_VERIFIED, (Object)this.lastVerified.toString());
        if (this.cacheToken != null) {
            cacheHeaders.put((Object)CACHE_TOKEN, (Object)this.cacheToken);
        }
        return cacheHeaders.build();
    }

    @Nullable
    public static CacheInfo fromMap(Map<String, String> map) {
        if (map != null) {
            return new CacheInfo(new DateTime((Object)map.get(LAST_VERIFIED)), map.get(CACHE_TOKEN));
        }
        return null;
    }

    @Nullable
    public static CacheInfo fromMap(AttributesMap map) {
        if (map != null) {
            return new CacheInfo(new DateTime(map.get(LAST_VERIFIED)), (String)map.get(CACHE_TOKEN, String.class));
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "lastVerified=" + this.lastVerified + ", cacheToken='" + this.cacheToken + '\'' + '}';
    }
}

