/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.cache.CacheController;

public class CacheControllerHolder {
    public static final CacheType CONTENT = new CacheType("CONTENT");
    public static final CacheType METADATA = new CacheType("METADATA");
    private final Map<CacheType, CacheController> controllers = new HashMap<CacheType, CacheController>();

    public CacheControllerHolder(CacheController contentCacheController, CacheController metadataCacheController) {
        this.controllers.put(CONTENT, (CacheController)((Object)Preconditions.checkNotNull((Object)((Object)contentCacheController))));
        this.controllers.put(METADATA, (CacheController)((Object)Preconditions.checkNotNull((Object)((Object)metadataCacheController))));
    }

    @Nonnull
    public CacheController getContentCacheController() {
        return (CacheController)((Object)Preconditions.checkNotNull((Object)((Object)this.controllers.get(CONTENT))));
    }

    @Nonnull
    public CacheController getMetadataCacheController() {
        return (CacheController)((Object)Preconditions.checkNotNull((Object)((Object)this.controllers.get(METADATA))));
    }

    @Nullable
    public CacheController get(CacheType cacheType) {
        return this.controllers.get(Preconditions.checkNotNull((Object)cacheType));
    }

    public CacheController require(CacheType cacheType) {
        return (CacheController)((Object)Preconditions.checkNotNull((Object)((Object)this.get(cacheType)), (Object)("Unexpected cache type: " + cacheType)));
    }

    @Nullable
    public CacheController set(CacheType cacheType, @Nullable CacheController cacheController) {
        Preconditions.checkNotNull((Object)cacheType);
        if (cacheController == null) {
            return this.controllers.remove(cacheType);
        }
        return this.controllers.put(cacheType, cacheController);
    }

    public void invalidateCaches() {
        this.controllers.values().forEach(CacheController::invalidateCache);
    }

    public static class CacheType {
        private final String typeName;

        public CacheType(String typeName) {
            this.typeName = (String)Preconditions.checkNotNull((Object)typeName);
        }

        public String value() {
            return this.typeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheType)) {
                return false;
            }
            CacheType cacheType = (CacheType)o;
            return this.value().equals(cacheType.value());
        }

        public int hashCode() {
            return this.value().hashCode();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "typeName='" + this.typeName + '\'' + '}';
        }
    }
}

