/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import java.util.logging.Level;

public class ODistributedServerLog {
    public static boolean isDebugEnabled() {
        return OLogManager.instance().isDebugEnabled();
    }

    public static void debug(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.FINE, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), null, true, null, iAdditionalArgs);
    }

    public static void debug(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.FINE, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), iException, true, null, iAdditionalArgs);
    }

    public static void info(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.INFO, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), null, true, null, iAdditionalArgs);
    }

    public static void info(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.INFO, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), iException, true, null, iAdditionalArgs);
    }

    public static void warn(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.WARNING, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), null, true, null, iAdditionalArgs);
    }

    public static void warn(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.WARNING, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), iException, true, null, iAdditionalArgs);
    }

    public static void error(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.SEVERE, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), null, true, null, iAdditionalArgs);
    }

    public static void error(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        OLogManager.instance().log(iRequester, Level.SEVERE, ODistributedServerLog.formatMessage(iRequester, iLocalNode, iRemoteNode, iDirection, iMessage), iException, true, null, iAdditionalArgs);
    }

    protected static String formatMessage(Object iRequester, String iLocalNode, String iRemoteNode, DIRECTION iDirection, String iMessage) {
        StringBuilder message = new StringBuilder(256);
        if (iLocalNode != null) {
            message.append('[');
            message.append(iLocalNode);
            message.append(']');
        }
        if (iRemoteNode != null && !iRemoteNode.equals(iLocalNode)) {
            switch (iDirection) {
                case IN: {
                    message.append("<-");
                    break;
                }
                case OUT: {
                    message.append("->");
                    break;
                }
                case BOTH: {
                    message.append("<>");
                    break;
                }
                case NONE: {
                    message.append("--");
                }
            }
            message.append('[');
            message.append(iRemoteNode);
            message.append(']');
        }
        message.append(' ');
        message.append(iMessage);
        return message.toString();
    }

    public static enum DIRECTION {
        NONE,
        IN,
        OUT,
        BOTH;

    }
}

