/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.internal.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.upgrade.AnalyticsPermissionReset;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
@FeatureFlag(name="nexus.analytics.permission.reset.enabled")
public class OrientAnalyticsPermissionReset
implements AnalyticsPermissionReset {
    protected static final String OSS = "OSS";
    protected static final String P_ENABLED = "enabled";
    protected static final String P_PROPERTIES = "properties";
    protected static final String P_TYPE = "type";
    protected static final String ANALYTICS_CAPABILITY = "analytics-configuration";
    protected static final String SUBMIT_ANALYTICS = "submitAnalytics";
    private final Provider<DatabaseInstance> config;
    private final ApplicationVersion applicationVersion;
    private static final Logger LOG = LoggerFactory.getLogger(OrientAnalyticsPermissionReset.class);
    private static final String DB_CLASS = new OClassNameBuilder().type("capability").build();

    @Inject
    public OrientAnalyticsPermissionReset(@Named(value="config") Provider<DatabaseInstance> config, ApplicationVersion applicationVersion) {
        this.config = config;
        this.applicationVersion = applicationVersion;
    }

    @Override
    public void resetAnalyticsPermissionIfDisabled() {
        if (!OSS.equals(this.applicationVersion.getEdition())) {
            return;
        }
        LOG.debug("Checking analytics permission ...");
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.config.get()).connect();){
            if (db.getMetadata().getSchema().existsClass(DB_CLASS)) {
                StreamSupport.stream(db.browseClass(DB_CLASS).spliterator(), false).filter(this::isAnalyticsCapability).findFirst().filter(this::isAnalyticsCapabilityDisabled).ifPresent(this::deleteCapability);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void deleteCapability(ODocument document) {
        LOG.debug("Resetting analytics permission ...");
        document.delete();
    }

    private boolean isAnalyticsCapability(ODocument document) {
        return StringUtils.equals((String)ANALYTICS_CAPABILITY, (String)((String)document.field(P_TYPE, OType.STRING)));
    }

    private boolean isAnalyticsCapabilityDisabled(ODocument document) {
        boolean enabled = (Boolean)document.field(P_ENABLED, OType.BOOLEAN);
        Map properties = (Map)document.field(P_PROPERTIES, OType.EMBEDDEDMAP);
        return !enabled || !Boolean.parseBoolean((String)properties.get(SUBMIT_ANALYTICS));
    }
}

