/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.upgrade.datastore.internal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.output.MigrateResult;
import org.slf4j.Logger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;
import org.sonatype.nexus.upgrade.datastore.internal.NexusJavaMigration;
import org.sonatype.nexus.upgrade.datastore.internal.TraceLoggingCallback;

abstract class UpgradeManagerSupport<E extends DatabaseMigrationStep>
extends ComponentSupport {
    private final List<E> migrations;
    private final DataSource dataSource;

    protected UpgradeManagerSupport(DataStoreManager dataStoreManager, String dataStoreName, List<E> migrations) {
        this.dataSource = ((DataStore)dataStoreManager.get(dataStoreName).orElseThrow(() -> new IllegalStateException("Missing DataStore named: " + dataStoreName))).getDataSource();
        this.migrations = migrations;
    }

    void migrate() {
        Callback[] callbackArray;
        JavaMigration[] flywayMigrations = (JavaMigration[])this.migrations.stream().map(NexusJavaMigration::new).toArray(JavaMigration[]::new);
        if (this.log.isDebugEnabled()) {
            this.migrations.forEach(m -> this.log.debug("Found migration: {} version:{}", m.getClass(), m.version()));
        }
        FluentConfiguration fluentConfiguration = Flyway.configure().dataSource(this.dataSource).javaMigrations(flywayMigrations);
        if (this.log.isTraceEnabled()) {
            Callback[] callbackArray2 = new Callback[1];
            callbackArray = callbackArray2;
            callbackArray2[0] = new TraceLoggingCallback();
        } else {
            callbackArray = new Callback[]{};
        }
        Flyway flyway = fluentConfiguration.callbacks(callbackArray).cleanDisabled(true).group(false).ignoreMigrationPatterns(new String[]{"*:missing"}).baselineOnMigrate(true).locations(new String[0]).outOfOrder(true).load();
        MigrateResult result = flyway.migrate();
        Preconditions.checkState((boolean)this.datastoreVersionIsAcceptable(flyway), (Object)"The database appears to be from a later version of Nexus Repository");
        int repeatableMigrations = this.migrations.size() - this.migrations.stream().map(DatabaseMigrationStep::version).filter(Optional::isPresent).collect(Collectors.counting()).intValue();
        if (result.migrationsExecuted > repeatableMigrations) {
            result.migrations.forEach(m -> this.log.info("{} migrated to v{} in {}s", new Object[]{m.description, m.version, m.executionTime}));
            result.warnings.forEach(arg_0 -> ((Logger)this.log).warn(arg_0));
            this.log.info("Completed migration from v{} to v{}", (Object)result.initialSchemaVersion, (Object)result.targetSchemaVersion);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("No migrations occurred migration of {} from {} to {}", new Object[]{result.schemaName, result.initialSchemaVersion, result.targetSchemaVersion});
        }
    }

    boolean datastoreVersionIsAcceptable(Flyway flyway) {
        List missingMigrations = Arrays.stream(flyway.info().applied()).filter(migrationInfo -> migrationInfo.getState() == MigrationState.FUTURE_SUCCESS).map(MigrationInfo::getDescription).collect(Collectors.toList());
        if (!missingMigrations.isEmpty()) {
            this.log.error("Missing migrations: {}", missingMigrations);
        }
        return missingMigrations.isEmpty();
    }
}

