/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ILock;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OCallableNoParamNoReturn;
import com.orientechnologies.common.util.OCallableUtils;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStartupException;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.impl.OClusterHealthChecker;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.task.ODropDatabaseTask;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateDatabaseConfigurationTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedMap;
import com.orientechnologies.orient.server.hazelcast.OHazelcastMergeStrategy;
import com.orientechnologies.orient.server.hazelcast.ONetworkSimulator;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.OBeforeDatabaseOpenNetworkEventListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import sun.misc.Signal;

public class OHazelcastPlugin
extends ODistributedAbstractPlugin
implements MembershipListener,
EntryListener<String, Object>,
LifecycleListener,
OBeforeDatabaseOpenNetworkEventListener {
    public static final String CONFIG_DATABASE_PREFIX = "database.";
    public static final String CONFIG_NODE_PREFIX = "node.";
    public static final String CONFIG_DBSTATUS_PREFIX = "dbstatus.";
    public static final String CONFIG_LOCKMANAGER = "coordinator";
    public static final String CONFIG_REGISTEREDNODES = "registeredNodes";
    protected String hazelcastConfigFile = "hazelcast.xml";
    protected Config hazelcastConfig;
    protected String membershipListenerRegistration;
    protected String membershipListenerMapRegistration;
    protected volatile HazelcastInstance hazelcastInstance;
    protected OHazelcastDistributedMap configurationMap;
    private OSignalHandler.OSignalListener signalListener;

    public void setHazelcastConfig(Config config) {
        this.hazelcastConfig = config;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        super.config(iServer, iParams);
        if (this.nodeName == null) {
            this.assignNodeName();
        }
        for (OServerParameterConfiguration param : iParams) {
            if (!param.name.equalsIgnoreCase("configuration.hazelcast")) continue;
            this.hazelcastConfigFile = OSystemVariableResolver.resolveSystemVariables((String)param.value);
            this.hazelcastConfigFile = OFileUtils.getPath((String)this.hazelcastConfigFile);
        }
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().setRunningDistributed(true);
        OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.setValue((Object)true);
        this.serverInstance.addTemporaryUser("_CrossServerTempUser", "" + new SecureRandom().nextLong(), "*");
        super.startup();
        this.status = ODistributedServerManager.NODE_STATUS.STARTING;
        String localNodeName = this.nodeName;
        this.activeNodes.clear();
        this.activeNodesNamesByUuid.clear();
        this.activeNodesUuidByName.clear();
        for (ORemoteServerController server : this.remoteServers.values()) {
            server.close();
        }
        this.remoteServers.clear();
        this.registeredNodeById.clear();
        this.registeredNodeByName.clear();
        try {
            long healthChecker;
            long statsDelay;
            this.hazelcastInstance = this.configureHazelcast();
            this.nodeUuid = this.hazelcastInstance.getCluster().getLocalMember().getUuid();
            LifecycleService lifecycleService = this.hazelcastInstance.getLifecycleService();
            lifecycleService.addLifecycleListener((LifecycleListener)this);
            OLogManager.instance().info((Object)this, "Starting distributed server '%s' (hzID=%s)...", new Object[]{localNodeName, this.nodeUuid});
            long clusterTime = this.getClusterTime();
            long deltaTime = System.currentTimeMillis() - clusterTime;
            OLogManager.instance().info((Object)this, "Distributed cluster time=%s (delta from local node=%d)...", new Object[]{new Date(clusterTime), deltaTime});
            this.activeNodes.put(localNodeName, this.hazelcastInstance.getCluster().getLocalMember());
            this.activeNodesNamesByUuid.put(this.nodeUuid, localNodeName);
            this.activeNodesUuidByName.put(localNodeName, this.nodeUuid);
            this.configurationMap = new OHazelcastDistributedMap(this, this.hazelcastInstance);
            OServer.registerServerInstance((String)localNodeName, (OServer)this.serverInstance);
            this.initRegisteredNodeIds();
            ODocument nodeCfg = new ODocument();
            nodeCfg.setTrackingChanges(false);
            HashSet node2Remove = new HashSet();
            for (Map.Entry entry : this.configurationMap.getHazelcastMap().entrySet()) {
                ODocument nCfg;
                if (!((String)entry.getKey()).startsWith(CONFIG_NODE_PREFIX) || !this.nodeName.equals((nCfg = (ODocument)entry.getValue()).field("name"))) continue;
                node2Remove.add(entry.getKey());
            }
            for (String n : node2Remove) {
                this.configurationMap.getHazelcastMap().remove((Object)n);
            }
            nodeCfg.field("id", (Object)this.nodeId);
            nodeCfg.field("uuid", (Object)this.nodeUuid);
            nodeCfg.field("name", (Object)this.nodeName);
            ORecordInternal.setRecordSerializer((ORecord)nodeCfg, (ORecordSerializer)ODatabaseDocumentTx.getDefaultSerializer());
            this.configurationMap.put(CONFIG_NODE_PREFIX + this.nodeUuid, (Object)nodeCfg);
            for (Object m : this.hazelcastInstance.getCluster().getMembers()) {
                if (m.getUuid().equals(this.nodeUuid)) continue;
                boolean found = false;
                for (int retry = 0; retry < 10; ++retry) {
                    String memberName = this.getNodeName((Member)m, false);
                    if (memberName != null && !memberName.startsWith("ext:")) {
                        found = true;
                        this.activeNodes.put(memberName, m);
                        this.activeNodesNamesByUuid.put(m.getUuid(), memberName);
                        this.activeNodesUuidByName.put(memberName, m.getUuid());
                        break;
                    }
                    Thread.sleep(1000L);
                }
                if (found) continue;
                ODistributedServerLog.warn((Object)((Object)this), (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot find configuration for member: %s, uuid", (Object[])new Object[]{m, m.getUuid()});
            }
            this.assignLockManagerFromCluster();
            this.messageService = new ODistributedMessageServiceImpl(this);
            this.initSystemDatabase();
            ODistributedServerLog.info((Object)((Object)this), (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Servers in cluster: %s", (Object[])new Object[]{this.activeNodes.keySet()});
            this.publishLocalNodeConfiguration();
            if (!this.configurationMap.containsKey(CONFIG_NODE_PREFIX + this.nodeUuid)) {
                ODistributedServerLog.error((Object)((Object)this), (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on registering local node on cluster", (Object[])new Object[0]);
                throw new ODistributedStartupException("Error on registering local node on cluster");
            }
            for (Object m : this.activeNodes.keySet()) {
                if (((String)m).equals(this.nodeName)) continue;
                this.getRemoteServer((String)m);
            }
            this.publishLocalNodeConfiguration();
            this.installNewDatabasesFromCluster();
            this.loadLocalDatabases();
            this.membershipListenerMapRegistration = this.configurationMap.getHazelcastMap().addEntryListener((EntryListener)this, true);
            this.membershipListenerRegistration = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)this);
            this.setNodeStatus(ODistributedServerManager.NODE_STATUS.ONLINE);
            this.publishLocalNodeConfiguration();
            long delay = OGlobalConfiguration.DISTRIBUTED_PUBLISH_NODE_STATUS_EVERY.getValueAsLong();
            if (delay > 0L) {
                this.publishLocalNodeConfigurationTask = new TimerTask(){

                    @Override
                    public void run() {
                        OHazelcastPlugin.this.publishLocalNodeConfiguration();
                    }
                };
                Orient.instance().scheduleTask(this.publishLocalNodeConfigurationTask, delay, delay);
            }
            if ((statsDelay = OGlobalConfiguration.DISTRIBUTED_DUMP_STATS_EVERY.getValueAsLong()) > 0L) {
                this.haStatsTask = new TimerTask(){

                    @Override
                    public void run() {
                        OHazelcastPlugin.this.dumpStats();
                    }
                };
                Orient.instance().scheduleTask(this.haStatsTask, statsDelay, statsDelay);
            }
            if ((healthChecker = OGlobalConfiguration.DISTRIBUTED_CHECK_HEALTH_EVERY.getValueAsLong()) > 0L) {
                this.healthCheckerTask = new OClusterHealthChecker(this, healthChecker);
                Orient.instance().scheduleTask((TimerTask)this.healthCheckerTask, healthChecker, healthChecker);
            }
            for (OServerNetworkListener nl : this.serverInstance.getNetworkListeners()) {
                nl.registerBeforeConnectNetworkEventListener((OBeforeDatabaseOpenNetworkEventListener)this);
            }
            this.waitStartupIsCompleted();
            this.signalListener = new OSignalHandler.OSignalListener(){

                public void onSignal(Signal signal) {
                    if (signal.toString().trim().equalsIgnoreCase("SIGTRAP")) {
                        OHazelcastPlugin.this.dumpStats();
                    }
                }
            };
            Orient.instance().getSignalHandler().registerListener(this.signalListener);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on starting distributed plugin", (Throwable)e, (Object[])new Object[0]);
            throw OException.wrapException((OException)new ODistributedStartupException("Error on starting distributed plugin"), (Throwable)e);
        }
        this.dumpServersStatus();
    }

    protected void initSystemDatabase() {
        ODocument defaultCfg = this.getStorage("OSystem").loadDatabaseConfiguration(this.getDefaultDatabaseConfigFile());
        defaultCfg.field("autoDeploy", (Object)false);
        OModifiableDistributedConfiguration sysCfg = new OModifiableDistributedConfiguration(defaultCfg);
        sysCfg.removeServer("<NEW_NODE>");
        this.messageService.registerDatabase("OSystem", (ODistributedConfiguration)sysCfg);
        sysCfg.addNewNodeInServerList(this.getLocalNodeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRegisteredNodeIds() {
        ILock lock = this.hazelcastInstance.getLock("orientdb.registeredNodes");
        lock.lock();
        try {
            this.registeredNodeById.clear();
            this.registeredNodeByName.clear();
            ODocument registeredNodesFromCluster = new ODocument();
            String registeredNodesFromClusterAsJson = (String)this.configurationMap.get(CONFIG_REGISTEREDNODES);
            if (registeredNodesFromClusterAsJson != null) {
                registeredNodesFromCluster.fromJSON(registeredNodesFromClusterAsJson);
                this.registeredNodeById.addAll((Collection)registeredNodesFromCluster.field("ids", OType.EMBEDDEDLIST));
                this.registeredNodeByName.putAll((Map)registeredNodesFromCluster.field("names", OType.EMBEDDEDMAP));
                if (this.registeredNodeByName.containsKey(this.nodeName)) {
                    this.nodeId = (Integer)this.registeredNodeByName.get(this.nodeName);
                } else {
                    this.registeredNodeById.add(this.nodeName);
                    this.nodeId = this.registeredNodeById.size() - 1;
                    this.registeredNodeByName.put(this.nodeName, this.nodeId);
                }
            } else if (this.hazelcastInstance.getCluster().getMembers().size() <= 1) {
                this.nodeId = 0;
                this.registeredNodeById.add(this.nodeName);
                this.registeredNodeByName.put(this.nodeName, this.nodeId);
            } else {
                this.repairActiveServers();
            }
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Registered local server with nodeId=%d", (Object[])new Object[]{this.nodeId});
            registeredNodesFromCluster.field("ids", (Object)this.registeredNodeById, new OType[]{OType.EMBEDDEDLIST});
            registeredNodesFromCluster.field("names", (Object)this.registeredNodeByName, new OType[]{OType.EMBEDDEDMAP});
            this.configurationMap.put(CONFIG_REGISTEREDNODES, (Object)registeredNodesFromCluster.toJSON());
        }
        finally {
            lock.unlock();
        }
        if (this.nodeId == -1) {
            throw new OConfigurationException("Cannot join the cluster (nodeId=-1). Please restart the server.");
        }
    }

    private void repairActiveServers() {
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on retrieving '%s' from cluster configuration. Repairing the configuration...", (Object[])new Object[]{CONFIG_REGISTEREDNODES});
        Set members = this.hazelcastInstance.getCluster().getMembers();
        for (Member m : members) {
            ODocument node = (ODocument)this.configurationMap.get(CONFIG_NODE_PREFIX + m.getUuid());
            if (node == null) continue;
            String mName = (String)node.field("name");
            Integer mId = (Integer)node.field("id");
            if (mId == null) {
                ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Found server '%s' with a NULL id", (Object[])new Object[]{mName});
                continue;
            }
            if (mId < 0) {
                ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Found server '%s' with an invalid id %d", (Object[])new Object[]{mName, mId});
                continue;
            }
            if (this.nodeName.equals(mName)) {
                this.nodeId = mId;
            }
            if (mId >= this.registeredNodeById.size()) {
                while (mId > this.registeredNodeById.size()) {
                    this.registeredNodeById.add(null);
                }
                this.registeredNodeById.add(mName);
            } else {
                this.registeredNodeById.set(mId, mName);
            }
            this.registeredNodeByName.put(mName, mId);
        }
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Repairing of '%s' completed, registered %d servers", (Object[])new Object[]{CONFIG_REGISTEREDNODES, members.size()});
    }

    public boolean isWriteQuorumPresent(String databaseName) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(databaseName);
        if (cfg != null) {
            int availableServers = this.getAvailableNodes(databaseName);
            if (availableServers == 0) {
                return false;
            }
            int quorum = cfg.getWriteQuorum(null, cfg.getMasterServers().size(), this.getLocalNodeName());
            return availableServers >= quorum;
        }
        return false;
    }

    @Override
    public int getNodeIdByName(String name) {
        int id = super.getNodeIdByName(name);
        if (name == null) {
            this.repairActiveServers();
            id = super.getNodeIdByName(name);
        }
        return id;
    }

    @Override
    public String getNodeNameById(int id) {
        String name = super.getNodeNameById(id);
        if (name == null) {
            this.repairActiveServers();
            name = super.getNodeNameById(id);
        }
        return name;
    }

    protected void waitStartupIsCompleted() throws InterruptedException {
        long totalReceivedRequests = this.getMessageService().getReceivedRequests();
        long totalProcessedRequests = this.getMessageService().getProcessedRequests();
        long start = System.currentTimeMillis();
        while (totalProcessedRequests < totalReceivedRequests - 2L && System.currentTimeMillis() - start < (long)OGlobalConfiguration.DISTRIBUTED_MAX_STARTUP_DELAY.getValueAsInteger()) {
            Thread.sleep(300L);
            totalProcessedRequests = this.getMessageService().getProcessedRequests();
            totalReceivedRequests = this.getMessageService().getReceivedRequests();
        }
        this.serverStarted.countDown();
    }

    protected void publishLocalNodeConfiguration() {
        try {
            ODocument cfg = this.getLocalNodeConfiguration();
            ORecordInternal.setRecordSerializer((ORecord)cfg, (ORecordSerializer)ODatabaseDocumentTx.getDefaultSerializer());
            this.configurationMap.put(CONFIG_NODE_PREFIX + this.nodeUuid, (Object)cfg);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on publishing local server configuration", (Object[])new Object[0]);
        }
    }

    protected void dumpStats() {
        try {
            ODocument clusterCfg = this.getClusterConfiguration();
            Set<String> dbs = this.getManagedDatabases();
            StringBuilder buffer = new StringBuilder(8192);
            buffer.append(ODistributedOutput.formatLatency(this, clusterCfg));
            buffer.append(ODistributedOutput.formatMessages(this, clusterCfg));
            OLogManager.instance().flush();
            buffer.append("\n" + this.getLockManagerExecutor().dumpLocks());
            for (String db : dbs) {
                buffer.append(this.messageService.getDatabase(db).dump());
            }
            System.out.println(buffer);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on printing HA stats", (Object[])new Object[0]);
        }
    }

    public Throwable convertException(Throwable original) {
        if (!Orient.instance().isActive() || this.isOffline()) {
            return new OOfflineNodeException("Server " + this.nodeName + " is offline");
        }
        if (original instanceof HazelcastException || original instanceof HazelcastInstanceNotActiveException) {
            return new IOException("Hazelcast wrapped exception: " + original.getMessage(), original.getCause());
        }
        if (original instanceof IllegalMonitorStateException) {
            return new IOException("Illegal monitor state: " + original.getMessage(), original.getCause());
        }
        return original;
    }

    public long getClusterTime() {
        if (this.hazelcastInstance == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        try {
            return this.hazelcastInstance.getCluster().getClusterTime();
        }
        catch (HazelcastInstanceNotActiveException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().getSignalHandler().unregisterListener(this.signalListener);
        for (OServerNetworkListener nl : this.serverInstance.getNetworkListeners()) {
            nl.unregisterBeforeConnectNetworkEventListener((OBeforeDatabaseOpenNetworkEventListener)this);
        }
        OLogManager.instance().warn((Object)this, "Shutting down node '%s'...", new Object[]{this.nodeName});
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN);
        try {
            HashSet databases = new HashSet();
            if (this.hazelcastInstance.getLifecycleService().isRunning()) {
                for (Map.Entry entry : this.configurationMap.entrySet()) {
                    String nodeDb;
                    if (!((String)entry.getKey()).toString().startsWith(CONFIG_DBSTATUS_PREFIX) || !(nodeDb = ((String)entry.getKey()).toString().substring(CONFIG_DBSTATUS_PREFIX.length())).startsWith(this.nodeName)) continue;
                    databases.add(entry.getKey());
                }
            }
            for (String string : databases) {
                this.configurationMap.put(string, (Object)ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
        }
        catch (HazelcastInstanceNotActiveException databases) {
            // empty catch block
        }
        try {
            super.shutdown();
        }
        catch (HazelcastInstanceNotActiveException databases) {
            // empty catch block
        }
        if (this.membershipListenerRegistration != null) {
            try {
                this.hazelcastInstance.getCluster().removeMembershipListener(this.membershipListenerRegistration);
            }
            catch (HazelcastInstanceNotActiveException databases) {
                // empty catch block
            }
        }
        if (this.hazelcastInstance != null) {
            try {
                this.hazelcastInstance.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on shutting down Hazelcast instance", (Throwable)e, new Object[0]);
            }
            finally {
                this.hazelcastInstance = null;
            }
        }
        OCallableUtils.executeIgnoringAnyExceptions((OCallableNoParamNoReturn)new OCallableNoParamNoReturn(){

            public void call() {
                OHazelcastPlugin.this.configurationMap.destroy();
            }
        });
        OCallableUtils.executeIgnoringAnyExceptions((OCallableNoParamNoReturn)new OCallableNoParamNoReturn(){

            public void call() {
                OHazelcastPlugin.this.configurationMap.getHazelcastMap().removeEntryListener(OHazelcastPlugin.this.membershipListenerMapRegistration);
            }
        });
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
    }

    public ORemoteServerController getRemoteServer(String rNodeName) throws IOException {
        if (rNodeName == null) {
            throw new IllegalArgumentException("Server name is NULL");
        }
        ORemoteServerController remoteServer = (ORemoteServerController)this.remoteServers.get(rNodeName);
        if (remoteServer == null) {
            Member member = this.getClusterMemberByName(rNodeName);
            for (int retry = 0; retry < 20; ++retry) {
                ODocument cfg = this.getNodeConfigurationByUuid(member.getUuid(), false);
                if (cfg == null || cfg.field("listeners") == null) {
                    try {
                        Thread.sleep(100L);
                        member = this.getClusterMemberByName(rNodeName);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw OException.wrapException((OException)new ODistributedException("Cannot find node '" + rNodeName + "' from server '" + this.getLocalNodeName() + "'"), (Throwable)e);
                    }
                }
                String url = ODistributedAbstractPlugin.getListeningBinaryAddress(cfg);
                if (url == null) {
                    this.closeRemoteServer(rNodeName);
                    throw new ODatabaseException("Cannot connect from server '" + this.getLocalNodeName() + "' to a remote node because the url was not found");
                }
                String userPassword = (String)cfg.field("user_replicator");
                if (userPassword != null) {
                    if (ONetworkSimulator.getInstance().areIsolated(this.getLocalNodeName(), rNodeName)) {
                        throw new SocketException("Servers '" + this.getLocalNodeName() + "' and '" + rNodeName + "' have been isolated through the network simulator");
                    }
                    remoteServer = new ORemoteServerController((ODistributedServerManager)this, rNodeName, url, "_CrossServerTempUser", userPassword);
                    ORemoteServerController old = this.remoteServers.putIfAbsent(rNodeName, remoteServer);
                    if (old == null) break;
                    remoteServer.close();
                    remoteServer = old;
                    break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw OException.wrapException((OException)new OInterruptedException("Cannot connect to remote server '" + rNodeName + "'"), (Throwable)e);
                }
            }
        }
        if (remoteServer == null) {
            throw new ODistributedException("Cannot find node '" + rNodeName + "'");
        }
        return remoteServer;
    }

    private Member getClusterMemberByName(String rNodeName) {
        Member member = (Member)this.activeNodes.get(rNodeName);
        if (member == null) {
            block0: for (Map.Entry<String, Object> entry : this.getConfigurationMap().localEntrySet()) {
                ODocument nodeCfg;
                if (!entry.getKey().startsWith(CONFIG_NODE_PREFIX) || !rNodeName.equals((nodeCfg = (ODocument)entry.getValue()).field("name"))) continue;
                String uuid = entry.getKey().substring(CONFIG_NODE_PREFIX.length());
                for (Member m : this.hazelcastInstance.getCluster().getMembers()) {
                    if (!m.getUuid().equals(uuid)) continue;
                    member = m;
                    this.registerNode(member, rNodeName);
                    continue block0;
                }
            }
            if (member == null) {
                throw new ODistributedException("Cannot find node '" + rNodeName + "'");
            }
        }
        return member;
    }

    public HazelcastInstance getHazelcastInstance() {
        int retry = 1;
        while (this.hazelcastInstance == null && !Thread.currentThread().isInterrupted()) {
            if (retry > 25) {
                throw new ODistributedException("Hazelcast instance is not available");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            ++retry;
        }
        return this.hazelcastInstance;
    }

    protected HazelcastInstance configureHazelcast() throws FileNotFoundException {
        if (this.hazelcastConfig == null) {
            this.hazelcastConfig = new FileSystemXmlConfig(this.hazelcastConfigFile);
            this.hazelcastConfig.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        }
        this.hazelcastConfig.getMapConfig(CONFIG_REGISTEREDNODES).setBackupCount(6);
        this.hazelcastConfig.getMapConfig("orientdb").setMergePolicy(OHazelcastMergeStrategy.class.getName());
        this.hazelcastConfig.setProperty("hazelcast.shutdownhook.enabled", "false");
        return Hazelcast.newHazelcastInstance((Config)this.hazelcastConfig);
    }

    @Override
    public String getPublicAddress() {
        return this.hazelcastConfig.getNetworkConfig().getPublicAddress();
    }

    protected void loadLocalDatabases() {
        ArrayList dbs = new ArrayList(this.serverInstance.getAvailableStorageNames().keySet());
        Collections.sort(dbs);
        for (final String databaseName : dbs) {
            if (this.messageService.getDatabase(databaseName) != null) continue;
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Opening database '%s'...", (Object[])new Object[]{databaseName});
            final ODistributedStorage stg = this.getStorage(databaseName);
            this.executeInDistributedDatabaseLock(databaseName, 60000L, null, new OCallable<Object, OModifiableDistributedConfiguration>(){

                public Object call(OModifiableDistributedConfiguration cfg) {
                    ODistributedServerLog.info((Object)this, (String)OHazelcastPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Current node started as %s for database '%s'", (Object[])new Object[]{cfg.getServerRole(OHazelcastPlugin.this.nodeName), databaseName});
                    ODistributedDatabaseImpl ddb = OHazelcastPlugin.this.messageService.registerDatabase(databaseName, (ODistributedConfiguration)cfg);
                    ddb.resume();
                    cfg.addNewNodeInServerList(OHazelcastPlugin.this.nodeName);
                    OHazelcastPlugin.this.reassignClustersOwnership(OHazelcastPlugin.this.nodeName, databaseName, cfg, true);
                    try {
                        ddb.getSyncConfiguration().setLastLSN(OHazelcastPlugin.this.nodeName, ((OLocalPaginatedStorage)stg.getUnderlying()).getLSN(), false);
                    }
                    catch (IOException e) {
                        ODistributedServerLog.error((Object)this, (String)OHazelcastPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on saving distributed LSN for database '%s' (err=%s).", (Object[])new Object[]{databaseName, e.getMessage()});
                    }
                    ddb.setOnline();
                    return null;
                }
            });
        }
    }

    public OHazelcastDistributedMap getConfigurationMap() {
        return this.configurationMap;
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    public boolean updateCachedDatabaseConfiguration(String databaseName, OModifiableDistributedConfiguration cfg, boolean iDeployToCluster) {
        this.getDistributedStrategy().validateConfiguration((ODistributedConfiguration)cfg);
        boolean updated = super.updateCachedDatabaseConfiguration(databaseName, cfg);
        if (!updated && !this.getConfigurationMap().containsKey(CONFIG_DATABASE_PREFIX + databaseName)) {
            updated = true;
        }
        ODocument document = cfg.getDocument();
        if (updated) {
            if (iDeployToCluster) {
                ORecordInternal.setRecordSerializer((ORecord)document, (ORecordSerializer)ODatabaseDocumentTx.getDefaultSerializer());
                this.configurationMap.put(CONFIG_DATABASE_PREFIX + databaseName, (Object)document);
                HashSet<String> servers = new HashSet<String>(this.getActiveServers());
                servers.remove(this.nodeName);
                if (!servers.isEmpty() && this.messageService.getDatabase(databaseName) != null) {
                    ODistributedResponse oDistributedResponse = this.sendRequest(databaseName, null, servers, (ORemoteTask)new OUpdateDatabaseConfigurationTask(databaseName, document), this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.NO_RESPONSE, null, null, null);
                }
            } else {
                this.configurationMap.putInLocalCache(CONFIG_DATABASE_PREFIX + databaseName, document);
            }
            this.serverInstance.getClientConnectionManager().pushDistribCfg2Clients(this.getClusterConfiguration());
            this.dumpServersStatus();
        }
        return updated;
    }

    public void entryAdded(EntryEvent<String, Object> iEvent) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        try {
            if (iEvent.getMember() == null) {
                return;
            }
            String eventNodeName = this.getNodeName(iEvent.getMember());
            if ("?".equals(eventNodeName)) {
                return;
            }
            String key = (String)iEvent.getKey();
            if (key.startsWith(CONFIG_NODE_PREFIX)) {
                if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember())) {
                    ODocument cfg = (ODocument)iEvent.getValue();
                    String joinedNodeName = (String)cfg.field("name");
                    if (this.nodeName.equals(joinedNodeName)) {
                        ODistributedServerLog.error((Object)((Object)this), (String)joinedNodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)("Found a new node (%s) with the same name as current: '" + joinedNodeName + "'. The node has been excluded. Change the name in its config/orientdb-dserver-config.xml file"), (Object[])new Object[]{iEvent.getMember()});
                        throw new ODistributedException("Found a new node (" + iEvent.getMember().toString() + ") with the same name as current: '" + joinedNodeName + "'. The node has been excluded. Change the name in its config/orientdb-dserver-config.xml file");
                    }
                    this.registerNode(iEvent.getMember(), joinedNodeName);
                }
            } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
                ODistributedServerManager.DB_STATUS s;
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received new status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
                String dbNode = key.substring(CONFIG_DBSTATUS_PREFIX.length());
                String nodeName = dbNode.substring(0, dbNode.indexOf("."));
                String databaseName = dbNode.substring(dbNode.indexOf(".") + 1);
                this.onDatabaseEvent(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                this.invokeOnDatabaseStatusChange(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember()) && ODistributedServerManager.DB_STATUS.ONLINE.equals(iEvent.getValue()) && (s = this.getDatabaseStatus(this.getLocalNodeName(), databaseName)) == ODistributedServerManager.DB_STATUS.NOT_AVAILABLE) {
                    this.installDatabase(false, databaseName, false, OGlobalConfiguration.DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST.getValueAsBoolean());
                }
            }
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
    }

    public void entryUpdated(EntryEvent<String, Object> iEvent) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        try {
            String key = (String)iEvent.getKey();
            String eventNodeName = this.getNodeName(iEvent.getMember());
            if ("?".equals(eventNodeName)) {
                return;
            }
            if (key.startsWith(CONFIG_NODE_PREFIX)) {
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Updated node configuration id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), eventNodeName});
                ODocument cfg = (ODocument)iEvent.getValue();
                if (!this.activeNodes.containsKey((String)cfg.field("name"))) {
                    this.updateLastClusterChange();
                }
                this.activeNodes.put((String)cfg.field("name"), iEvent.getMember());
                if (iEvent.getMember().getUuid() != null) {
                    this.activeNodesNamesByUuid.put(iEvent.getMember().getUuid(), (String)cfg.field("name"));
                    this.activeNodesUuidByName.put((String)cfg.field("name"), iEvent.getMember().getUuid());
                }
                this.dumpServersStatus();
            } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
                ODistributedServerManager.DB_STATUS s;
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received updated status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
                String dbNode = key.substring(CONFIG_DBSTATUS_PREFIX.length());
                String nodeName = dbNode.substring(0, dbNode.indexOf("."));
                String databaseName = dbNode.substring(dbNode.indexOf(".") + 1);
                this.onDatabaseEvent(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                this.invokeOnDatabaseStatusChange(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember()) && ODistributedServerManager.DB_STATUS.ONLINE.equals(iEvent.getValue()) && (s = this.getDatabaseStatus(this.getLocalNodeName(), databaseName)) == ODistributedServerManager.DB_STATUS.NOT_AVAILABLE) {
                    this.installDatabase(false, databaseName, false, OGlobalConfiguration.DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST.getValueAsBoolean());
                }
            } else if (key.startsWith(CONFIG_REGISTEREDNODES)) {
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received updated about registered nodes", (Object[])new Object[0]);
                this.reloadRegisteredNodes((String)iEvent.getValue());
            } else if (key.startsWith(CONFIG_LOCKMANAGER)) {
                this.getLockManagerRequester().setServer((String)iEvent.getValue());
            }
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
    }

    public void entryRemoved(EntryEvent<String, Object> iEvent) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        try {
            String key = (String)iEvent.getKey();
            String eventNodeName = this.getNodeName(iEvent.getMember());
            if ("?".equals(eventNodeName)) {
                return;
            }
            if (key.startsWith(CONFIG_NODE_PREFIX)) {
                if (eventNodeName != null) {
                    ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removed node configuration id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), eventNodeName});
                    this.activeNodes.remove(eventNodeName);
                    this.activeNodesNamesByUuid.remove(iEvent.getMember().getUuid());
                    this.activeNodesUuidByName.remove(eventNodeName);
                    this.closeRemoteServer(eventNodeName);
                }
                this.updateLastClusterChange();
                this.dumpServersStatus();
            } else if (key.startsWith(CONFIG_DATABASE_PREFIX)) {
                String dbName = key.substring(CONFIG_DATABASE_PREFIX.length());
                ODistributedStorage stg = (ODistributedStorage)this.storages.remove(dbName);
                if (stg != null) {
                    stg.close(true, false);
                }
                this.updateLastClusterChange();
            } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)this.getNodeName(iEvent.getMember()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received removed status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
                String dbNode = key.substring(CONFIG_DBSTATUS_PREFIX.length());
                String nodeName = dbNode.substring(0, dbNode.indexOf("."));
                String databaseName = dbNode.substring(dbNode.indexOf(".") + 1);
                this.onDatabaseEvent(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
            }
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
    }

    public void entryEvicted(EntryEvent<String, Object> iEvent) {
    }

    public void mapEvicted(MapEvent iEvent) {
    }

    public void mapCleared(MapEvent event) {
    }

    public void memberRemoved(MembershipEvent iEvent) {
        try {
            this.updateLastClusterChange();
            if (iEvent.getMember() == null) {
                return;
            }
            String nodeLeftName = this.getNodeName(iEvent.getMember());
            if (nodeLeftName == null) {
                return;
            }
            this.removeServer(nodeLeftName, true);
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on removing the server '%s'", (Throwable)e, new Object[]{this.getNodeName(iEvent.getMember())});
        }
    }

    public void memberAdded(MembershipEvent iEvent) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        try {
            this.updateLastClusterChange();
            String addedNodeName = this.getNodeName(iEvent.getMember());
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Added new node id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), addedNodeName});
            this.registerNode(iEvent.getMember(), addedNodeName);
            this.autoRemovalOfServers.remove(addedNodeName);
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
    }

    public void stateChanged(LifecycleEvent event) {
        LifecycleEvent.LifecycleState state = event.getState();
        if (state == LifecycleEvent.LifecycleState.MERGING) {
            this.setNodeStatus(ODistributedServerManager.NODE_STATUS.MERGING);
        } else if (state == LifecycleEvent.LifecycleState.MERGED) {
            this.getLockManagerRequester().setServer((String)this.configurationMap.getHazelcastMap().get((Object)CONFIG_LOCKMANAGER));
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Server merged the existent cluster, lockManager=%s, merging databases...", (Object[])new Object[]{this.getLockManagerServer()});
            this.configurationMap.clearLocalCache();
            String oldUuid = this.nodeUuid;
            this.nodeUuid = this.hazelcastInstance.getCluster().getLocalMember().getUuid();
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Replacing old UUID %s with the new %s", (Object[])new Object[]{oldUuid, this.nodeUuid});
            this.activeNodesNamesByUuid.remove(oldUuid);
            this.configurationMap.remove(CONFIG_NODE_PREFIX + oldUuid);
            this.activeNodes.put(this.nodeName, this.hazelcastInstance.getCluster().getLocalMember());
            this.activeNodesNamesByUuid.put(this.nodeUuid, this.nodeName);
            this.activeNodesUuidByName.put(this.nodeName, this.nodeUuid);
            this.publishLocalNodeConfiguration();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ODistributedServerLog.info((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Merging networks, waiting for the lockManager %s to be reachable...", (Object[])new Object[]{OHazelcastPlugin.this.getLockManagerServer()});
                        for (int retry = 0; !OHazelcastPlugin.this.getActiveServers().contains(OHazelcastPlugin.this.getLockManagerServer()) && retry < 10; ++retry) {
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        String cs = OHazelcastPlugin.this.getLockManagerServer();
                        ODistributedServerLog.info((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Merging networks, lockManager=%s (active=%s)...", (Object[])new Object[]{cs, OHazelcastPlugin.this.getActiveServers().contains(OHazelcastPlugin.this.getLockManagerServer())});
                        for (final String databaseName : OHazelcastPlugin.this.getMessageService().getDatabases()) {
                            OHazelcastPlugin.this.executeInDistributedDatabaseLock(databaseName, 20000L, null, new OCallable<Object, OModifiableDistributedConfiguration>(){

                                public Object call(OModifiableDistributedConfiguration cfg) {
                                    ODistributedServerLog.debug((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Replacing local database '%s' configuration with the most recent from the joined cluster...", (Object[])new Object[]{databaseName});
                                    cfg.override((ODocument)OHazelcastPlugin.this.configurationMap.get(OHazelcastPlugin.CONFIG_DATABASE_PREFIX + databaseName));
                                    return null;
                                }
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        ODistributedServerLog.warn((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Network merged, lockManager=%s...", (Object[])new Object[]{OHazelcastPlugin.this.getLockManagerServer()});
                        OHazelcastPlugin.this.setNodeStatus(ODistributedServerManager.NODE_STATUS.ONLINE);
                        throw throwable;
                    }
                    ODistributedServerLog.warn((Object)this, (String)OHazelcastPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Network merged, lockManager=%s...", (Object[])new Object[]{OHazelcastPlugin.this.getLockManagerServer()});
                    OHazelcastPlugin.this.setNodeStatus(ODistributedServerManager.NODE_STATUS.ONLINE);
                }
            });
            t.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new OUncaughtExceptionHandler());
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(ODatabaseInternal iDatabase) {
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        if (this.status != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return;
        }
        ODatabaseDocumentInternal currDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            String dbName = iDatabase.getName();
            ODocument dCfg = (ODocument)this.configurationMap.get(CONFIG_DATABASE_PREFIX + dbName);
            if (dCfg != null && this.getAvailableNodes(dbName) > 0) {
                throw new ODistributedException("Cannot create the new database '" + dbName + "' because it is already present in distributed configuration");
            }
            this.getStorage(dbName);
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(dbName);
            ODistributedDatabaseImpl distribDatabase = this.messageService.registerDatabase(dbName, cfg);
            distribDatabase.checkNodeInConfiguration(cfg, this.getLocalNodeName());
            distribDatabase.resume();
            distribDatabase.setOnline();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw OException.wrapException((OException)new ODistributedException("Error on creating database '" + dbName + "' on distributed nodes"), (Throwable)e);
            }
            Set servers = cfg.getAllConfiguredServers();
            if (servers.size() > 1) {
                int retry;
                for (retry = 0; retry < 100; ++retry) {
                    boolean allServersAreOnline = true;
                    for (String server : servers) {
                        if (this.isNodeOnline(server, dbName)) continue;
                        allServersAreOnline = false;
                        break;
                    }
                    if (allServersAreOnline) break;
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw OException.wrapException((OException)new ODistributedException("Error on creating database '" + dbName + "' on distributed nodes"), (Throwable)e);
                    }
                }
                if (retry >= 100) {
                    ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Timeout waiting for all nodes to be up for database %s", (Object[])new Object[]{dbName});
                }
            }
            this.onOpen(iDatabase);
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(currDb);
        }
    }

    @Override
    public void onDrop(ODatabaseInternal iDatabase) {
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        String dbName = iDatabase.getName();
        ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Dropping database %s...", (Object[])new Object[]{dbName});
        if (!OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            ODistributedConfiguration dCfg = this.getDatabaseConfiguration(dbName);
            Set servers = dCfg.getAllConfiguredServers();
            servers.remove(this.nodeName);
            long start = System.currentTimeMillis();
            boolean allServersAreOnline = false;
            block2: while (!allServersAreOnline && System.currentTimeMillis() - start < 5000L) {
                allServersAreOnline = true;
                for (String s : servers) {
                    ODistributedServerManager.DB_STATUS st = this.getDatabaseStatus(s, dbName);
                    if (st != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE && st != ODistributedServerManager.DB_STATUS.SYNCHRONIZING && st != ODistributedServerManager.DB_STATUS.BACKUP) continue;
                    allServersAreOnline = false;
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue block2;
                    }
                }
            }
            if (!servers.isEmpty() && this.messageService.getDatabase(dbName) != null) {
                this.sendRequest(dbName, null, servers, (ORemoteTask)new ODropDatabaseTask(), this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            }
        }
        super.onDrop(iDatabase);
        if (this.configurationMap != null) {
            this.configurationMap.remove(CONFIG_DBSTATUS_PREFIX + this.nodeName + "." + dbName);
            if (!OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
                this.configurationMap.remove(CONFIG_DATABASE_PREFIX + dbName);
                this.configurationMap.remove("deploydb." + dbName);
                ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Dropped last copy of database '%s', removing it from the cluster", (Object[])new Object[]{dbName});
            }
        }
    }

    public ODocument getNodeConfigurationByUuid(String iNodeId, boolean useCache) {
        if (this.configurationMap == null) {
            return null;
        }
        ODocument doc = (ODocument)(useCache ? this.configurationMap.getLocalCachedValue(CONFIG_NODE_PREFIX + iNodeId) : this.configurationMap.get(CONFIG_NODE_PREFIX + iNodeId));
        if (doc == null) {
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Cannot find node with id '%s'", (Object[])new Object[]{iNodeId});
        }
        return doc;
    }

    public ODistributedServerManager.DB_STATUS getDatabaseStatus(String iNode, String iDatabaseName) {
        if ("OSystem".equals(iDatabaseName)) {
            return this.getActiveServers().contains(iNode) ? ODistributedServerManager.DB_STATUS.ONLINE : ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
        }
        ODistributedServerManager.DB_STATUS status = (ODistributedServerManager.DB_STATUS)this.configurationMap.getLocalCachedValue(CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName);
        return status != null ? status : ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
    }

    public ODistributedServerManager.DB_STATUS getDatabaseStatus(String iNode, String iDatabaseName, boolean useCache) {
        if ("OSystem".equals(iDatabaseName)) {
            return this.getActiveServers().contains(iNode) ? ODistributedServerManager.DB_STATUS.ONLINE : ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
        }
        String key = CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName;
        ODistributedServerManager.DB_STATUS status = (ODistributedServerManager.DB_STATUS)(useCache ? this.configurationMap.getLocalCachedValue(key) : this.configurationMap.get(key));
        return status != null ? status : ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
    }

    public void setDatabaseStatus(String iNode, String iDatabaseName, ODistributedServerManager.DB_STATUS iStatus) {
        String key = CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName;
        ODistributedServerManager.DB_STATUS currStatus = (ODistributedServerManager.DB_STATUS)this.configurationMap.get(key);
        if (currStatus == null || currStatus != iStatus) {
            this.configurationMap.put(key, (Object)iStatus);
            this.invokeOnDatabaseStatusChange(iNode, iDatabaseName, iStatus);
        }
    }

    private void invokeOnDatabaseStatusChange(String iNode, String iDatabaseName, ODistributedServerManager.DB_STATUS iStatus) {
        for (ODistributedLifecycleListener l : this.listeners) {
            try {
                l.onDatabaseChangeStatus(iNode, iDatabaseName, iStatus);
            }
            catch (Exception exception) {}
        }
    }

    protected void installNewDatabasesFromCluster() {
        if (this.activeNodes.size() <= 1) {
            return;
        }
        ArrayList<String> dbs = new ArrayList<String>(this.configurationMap.getKeySet());
        Collections.sort(dbs);
        for (String key : dbs) {
            String databaseName;
            Set<String> availableServers;
            if (!key.startsWith(CONFIG_DATABASE_PREFIX) || (availableServers = this.getAvailableNodeNames(databaseName = key.substring(CONFIG_DATABASE_PREFIX.length()))).isEmpty()) continue;
            ODistributedServerManager.DB_STATUS currStatus = this.getDatabaseStatus(this.nodeName, databaseName);
            if (currStatus == ODistributedServerManager.DB_STATUS.SYNCHRONIZING || currStatus == ODistributedServerManager.DB_STATUS.ONLINE || currStatus == ODistributedServerManager.DB_STATUS.BACKUP) {
                this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
            try {
                this.installDatabase(true, databaseName, false, OGlobalConfiguration.DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST.getValueAsBoolean());
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on installing database '%s' on local node (error=%s)", (Object[])new Object[]{databaseName, e.toString()});
                this.setDatabaseStatus(this.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
        }
    }

    public void reloadRegisteredNodes(String registeredNodesFromClusterAsJson) {
        ODocument registeredNodesFromCluster = new ODocument();
        if (registeredNodesFromClusterAsJson == null) {
            registeredNodesFromClusterAsJson = (String)this.configurationMap.get(CONFIG_REGISTEREDNODES);
        }
        if (registeredNodesFromClusterAsJson == null) {
            throw new ODistributedException("Cannot find distributed 'registeredNodes' configuration");
        }
        registeredNodesFromCluster.fromJSON(registeredNodesFromClusterAsJson);
        this.registeredNodeById.clear();
        this.registeredNodeById.addAll((Collection)registeredNodesFromCluster.field("ids", OType.EMBEDDEDLIST));
        this.registeredNodeByName.clear();
        this.registeredNodeByName.putAll((Map)registeredNodesFromCluster.field("names", OType.EMBEDDEDMAP));
    }

    private List<String> getRegisteredNodes() {
        ArrayList<String> registeredNodes = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.configurationMap.entrySet()) {
            if (!entry.getKey().toString().startsWith(CONFIG_NODE_PREFIX)) continue;
            registeredNodes.add(entry.getKey().toString().substring(CONFIG_NODE_PREFIX.length()));
        }
        return registeredNodes;
    }

    public void removeNodeFromConfiguration(String nodeLeftName, boolean removeOnlyDynamicServers) {
        ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removing server '%s' from all the databases (removeOnlyDynamicServers=%s)...", (Object[])new Object[]{nodeLeftName, removeOnlyDynamicServers});
        for (String dbName : this.getManagedDatabases()) {
            this.removeNodeFromConfiguration(nodeLeftName, dbName, removeOnlyDynamicServers, false);
        }
    }

    public boolean removeNodeFromConfiguration(final String nodeLeftName, String databaseName, boolean removeOnlyDynamicServers, boolean statusOffline) {
        ODistributedServerLog.debug((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removing server '%s' from database configuration '%s' (removeOnlyDynamicServers=%s)...", (Object[])new Object[]{nodeLeftName, databaseName, removeOnlyDynamicServers});
        OModifiableDistributedConfiguration cfg = this.getDatabaseConfiguration(databaseName).modify();
        if (removeOnlyDynamicServers) {
            String dc = cfg.getDataCenterOfServer(nodeLeftName);
            if (dc != null) {
                ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot remove server '%s' because it is enlisted in data center '%s' configuration for database '%s'", (Object[])new Object[]{nodeLeftName, dc, databaseName});
                return false;
            }
            Set registeredServers = cfg.getRegisteredServers();
            if (registeredServers.contains(nodeLeftName)) {
                ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot remove server '%s' because it is enlisted in 'servers' of the distributed configuration for database '%s'", (Object[])new Object[]{nodeLeftName, databaseName});
                return false;
            }
        }
        boolean found = this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

            public Boolean call(OModifiableDistributedConfiguration cfg) {
                return cfg.removeServer(nodeLeftName) != null;
            }
        });
        ODistributedServerManager.DB_STATUS nodeLeftStatus = this.getDatabaseStatus(nodeLeftName, databaseName);
        if (statusOffline && nodeLeftStatus != ODistributedServerManager.DB_STATUS.OFFLINE) {
            this.setDatabaseStatus(nodeLeftName, databaseName, ODistributedServerManager.DB_STATUS.OFFLINE);
        } else if (!statusOffline && nodeLeftStatus != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE) {
            this.setDatabaseStatus(nodeLeftName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
        }
        return found;
    }

    public void removeServer(final String nodeLeftName, final boolean removeOnlyDynamicServers) {
        if (nodeLeftName == null) {
            return;
        }
        Member member = (Member)this.activeNodes.remove(nodeLeftName);
        if (member == null) {
            return;
        }
        ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed server '%s' is unreachable", (Object[])new Object[]{nodeLeftName});
        try {
            if (nodeLeftName.equals(this.getLockManagerRequester().getServer())) {
                this.electNewLockManager();
            }
            this.getLockManagerExecutor().handleUnreachableServer(nodeLeftName);
            this.getLockManagerRequester().handleUnreachableServer(nodeLeftName);
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on electing new lockManager", (Throwable)e, (Object[])new Object[0]);
        }
        if (nodeLeftName.equals(this.getLockManagerRequester().getServer())) {
            return;
        }
        try {
            this.closeRemoteServer(nodeLeftName);
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on closing remote server connection", (Throwable)e, (Object[])new Object[]{nodeLeftName});
        }
        for (ODistributedLifecycleListener l : this.listeners) {
            try {
                l.onNodeLeft(nodeLeftName);
            }
            catch (Exception e) {
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on calling onNodeLeft event on '%s'", (Throwable)e, (Object[])new Object[]{l});
            }
        }
        if (this.messageService != null) {
            for (String dbName : this.messageService.getDatabases()) {
                try {
                    this.messageService.getDatabase(dbName).handleUnreachableNode(nodeLeftName);
                }
                catch (Exception e) {
                    ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on handling an unreachable node", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
        try {
            if (member.getUuid() != null) {
                this.activeNodesNamesByUuid.remove(member.getUuid());
            }
            this.activeNodesUuidByName.remove(nodeLeftName);
            if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
                return;
            }
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on removing the node from Hazelcast", (Throwable)e, (Object[])new Object[0]);
        }
        try {
            long autoRemoveOffLineServer = OGlobalConfiguration.DISTRIBUTED_AUTO_REMOVE_OFFLINE_SERVERS.getValueAsLong();
            if (autoRemoveOffLineServer == 0L) {
                this.removeNodeFromConfiguration(nodeLeftName, removeOnlyDynamicServers);
            } else if (autoRemoveOffLineServer > 0L) {
                final long currentTime = System.currentTimeMillis();
                this.autoRemovalOfServers.put(nodeLeftName, currentTime);
                Orient.instance().scheduleTask(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Long lastTimeNodeLeft = (Long)OHazelcastPlugin.this.autoRemovalOfServers.get(nodeLeftName);
                            if (lastTimeNodeLeft == null) {
                                return;
                            }
                            if (lastTimeNodeLeft == currentTime) {
                                OHazelcastPlugin.this.removeNodeFromConfiguration(nodeLeftName, removeOnlyDynamicServers);
                            }
                        }
                        catch (Exception e) {
                            ODistributedServerLog.debug((Object)this, (String)OHazelcastPlugin.this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on removing the node from distributed configuration", (Throwable)e, (Object[])new Object[0]);
                        }
                    }
                }, autoRemoveOffLineServer, 0L);
            }
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on removing the node from distributed configuration", (Throwable)e, (Object[])new Object[0]);
        }
        for (String databaseName : this.getManagedDatabases()) {
            try {
                ODistributedServerManager.DB_STATUS nodeLeftStatus = this.getDatabaseStatus(nodeLeftName, databaseName);
                if (nodeLeftStatus == ODistributedServerManager.DB_STATUS.OFFLINE || nodeLeftStatus == ODistributedServerManager.DB_STATUS.NOT_AVAILABLE) continue;
                this.configurationMap.put(CONFIG_DBSTATUS_PREFIX + nodeLeftName + "." + databaseName, (Object)ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
            catch (Exception e) {
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on removing the node from Hazelcast configuration", (Throwable)e, (Object[])new Object[0]);
            }
        }
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Node removed id=%s name=%s", (Object[])new Object[]{member, nodeLeftName});
        if (nodeLeftName.startsWith("ext:")) {
            List<String> registeredNodes = this.getRegisteredNodes();
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removed node id=%s name=%s has not being recognized. Remove the node manually (registeredNodes=%s)", (Object[])new Object[]{member, nodeLeftName, registeredNodes});
        }
        for (String databaseName : this.getManagedDatabases()) {
            try {
                this.reassignClustersOwnership(this.nodeName, databaseName, null, false);
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot re-balance the cluster for database '%s' because the lockManager is not available (err=%s)", (Object[])new Object[]{databaseName, e.getMessage()});
            }
        }
        if (this.messageService != null) {
            this.messageService.handleUnreachableNode(nodeLeftName);
        }
        if (nodeLeftName.equalsIgnoreCase(this.nodeName)) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String electNewLockManager() {
        if (this.hazelcastInstance == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        ILock lock = this.hazelcastInstance.getLock("orientdb.lockManagerElection");
        lock.lock();
        try {
            String lockManagerServer = this.getLockManagerRequester().getServer();
            if (lockManagerServer != null && this.getActiveServers().contains(lockManagerServer)) {
                String string = lockManagerServer;
                return string;
            }
            String originalLockManager = lockManagerServer;
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)originalLockManager, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"lockManager '%s' is unreachable, electing a new lockManager...", (Object[])new Object[]{originalLockManager});
            int lockManagerServerId = -1;
            if (lockManagerServer != null && this.registeredNodeByName.containsKey(lockManagerServer)) {
                lockManagerServerId = (Integer)this.registeredNodeByName.get(lockManagerServer);
            }
            String newServer = null;
            int currIndex = lockManagerServerId;
            for (int i = 0; i < this.registeredNodeById.size(); ++i) {
                if (++currIndex >= this.registeredNodeById.size()) {
                    currIndex = 0;
                }
                if ((newServer = (String)this.registeredNodeById.get(currIndex)) == null) {
                    throw new OConfigurationException("Found null server at index " + currIndex + " of server list " + this.registeredNodeById);
                }
                if (!newServer.equalsIgnoreCase(this.getLocalNodeName()) && !this.activeNodes.containsKey(newServer)) continue;
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)newServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Trying to elected server '%s' as new lockManager (old=%s)...", (Object[])new Object[]{newServer, originalLockManager});
                try {
                    this.getLockManagerRequester().setServer(newServer);
                    this.configurationMap.put(CONFIG_LOCKMANAGER, (Object)this.getLockManagerRequester().getServer());
                    ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)newServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Elected server '%s' as new lockManager (old=%s)", (Object[])new Object[]{newServer, originalLockManager});
                    break;
                }
                catch (Exception e) {
                    ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)newServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on electing server '%s' as new lockManager (error: %s)", (Object[])new Object[]{newServer, e});
                }
            }
            String string = newServer;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<String> getActiveServers() {
        return this.activeNodes.keySet();
    }

    public void onBeforeDatabaseOpen(String url) {
        ODistributedDatabaseImpl dDatabase = this.getMessageService().getDatabase(OUtils.getDatabaseNameFromURL((String)url));
        if (dDatabase != null) {
            dDatabase.waitForOnline();
        }
    }

    protected void registerNode(Member member, String joinedNodeName) {
        if (this.activeNodes.containsKey(joinedNodeName)) {
            return;
        }
        if (joinedNodeName.startsWith("ext:")) {
            return;
        }
        if (this.activeNodes.putIfAbsent(joinedNodeName, member) == null) {
            for (ODistributedLifecycleListener l : this.listeners) {
                if (l.onNodeJoining(joinedNodeName)) continue;
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)this.getNodeName(member), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Denied node to join the cluster id=%s name=%s", (Object[])new Object[]{member, this.getNodeName(member)});
                this.activeNodes.remove(joinedNodeName);
                return;
            }
            this.activeNodesNamesByUuid.put(member.getUuid(), joinedNodeName);
            this.activeNodesUuidByName.put(joinedNodeName, member.getUuid());
            try {
                this.getRemoteServer(joinedNodeName);
            }
            catch (IOException e) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)joinedNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on connecting to node %s", (Object[])new Object[]{joinedNodeName});
            }
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)this.getNodeName(member), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Added node configuration id=%s name=%s, now %d nodes are configured", (Object[])new Object[]{member, this.getNodeName(member), this.activeNodes.size()});
            for (ODistributedLifecycleListener l : this.listeners) {
                l.onNodeJoined(joinedNodeName);
            }
            for (String db : this.messageService.getDatabases()) {
                if (!this.getDatabaseConfiguration(db).isAutoDeploy() || this.getDatabaseStatus(joinedNodeName, db) != ODistributedServerManager.DB_STATUS.ONLINE) continue;
                this.setDatabaseStatus(joinedNodeName, db, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
            this.dumpServersStatus();
        }
    }

    private void assignLockManagerFromCluster() {
        String lockManagerServer = null;
        while (lockManagerServer == null) {
            if (this.activeNodes.size() == 1) {
                lockManagerServer = this.nodeName;
                if (this.configurationMap.putIfAbsent(CONFIG_LOCKMANAGER, (Object)lockManagerServer) == null) {
                    break;
                }
            } else {
                lockManagerServer = (String)this.configurationMap.get(CONFIG_LOCKMANAGER);
                if (lockManagerServer != null && lockManagerServer.equals(this.nodeName)) {
                    OLogManager.instance().info((Object)this, "Found lockManager as current node, even if it was offline. Forcing a new election...", new Object[0]);
                    this.getLockManagerRequester().setServer(lockManagerServer);
                    lockManagerServer = this.electNewLockManager();
                    break;
                }
                if (lockManagerServer != null) break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.getLockManagerRequester().setServer(lockManagerServer);
        OLogManager.instance().info((Object)this, "Distributed lockManager='%s'", new Object[]{lockManagerServer});
    }
}

