/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasklog;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class TaskLogCleanupQuartz
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final String taskLogCleanupCron;

    @Inject
    public TaskLogCleanupQuartz(TaskScheduler taskScheduler, @Named(value="${nexus.tasks.log.cleanup.cron:-0 0 0 * * ?}") String taskLogCleanupCron) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.taskLogCleanupCron = (String)Preconditions.checkNotNull((Object)taskLogCleanupCron);
    }

    protected void doStart() throws Exception {
        if (!this.taskScheduler.listsTasks().stream().anyMatch(info -> "tasklog.cleanup".equals(info.getConfiguration().getTypeId()))) {
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("tasklog.cleanup");
            Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.taskLogCleanupCron);
            this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
        }
    }
}

