/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.helm.internal;

import com.sonatype.nexus.blobstore.restore.helm.internal.HelmRestoreBlobData;
import com.sonatype.repository.helm.datastore.HelmRestoreFacet;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="helm")
@Singleton
public class HelmRestoreBlobStrategy
extends BaseRestoreBlobStrategy<HelmRestoreBlobData> {
    private final RepositoryManager repositoryManager;

    @Inject
    protected HelmRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = repositoryManager;
    }

    public void after(boolean updateAssets, Repository repository) {
    }

    protected boolean canAttemptRestore(@Nonnull HelmRestoreBlobData data) {
        Repository repository = data.getRepository();
        Optional maybeHelmRestoreFacet = repository.optionalFacet(HelmRestoreFacet.class);
        if (!maybeHelmRestoreFacet.isPresent()) {
            this.log.warn("Skipping as Helm Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        HelmRestoreFacet helmRestoreFacet = (HelmRestoreFacet)maybeHelmRestoreFacet.get();
        return helmRestoreFacet.isRestorable(this.getAssetPath(data));
    }

    protected void createAssetFromBlob(Blob blob, HelmRestoreBlobData data) throws IOException {
        Repository repository = data.getRepository();
        HelmRestoreFacet helmRestoreFacet = (HelmRestoreFacet)repository.facet(HelmRestoreFacet.class);
        String path = this.getAssetPath(data);
        helmRestoreFacet.restore(blob, path);
    }

    protected String getAssetPath(@Nonnull HelmRestoreBlobData data) {
        return data.getBlobName();
    }

    protected HelmRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new HelmRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(HelmRestoreBlobData data) {
        return true;
    }
}

