/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.npm.metadata.export;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.npm.metadata.export.NpmPackageRootExporter;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String LONG_OPT_ARG = "D";
    private static final String ORIENTDB_URL_ARG = "db.url";
    private static final String EXPORT_DIRECTORY_ARG = "export.directory";
    private static final String REPOSITORY_NAME_ARG = "repository.name";
    private static final String ABBREVIATED_PACKAGEROOT_ARG = "abbreviated.packageroot";
    private static final String NAME = "name";
    private static final String DIST_TAGS = "dist-tags";
    private static final String ORIENT_USERNAME = "admin";
    private static final String ORIENT_USER_PASSWORD = "admin";
    private static final ObjectMapper READ_MAPPER = new ObjectMapper((JsonFactory)new SmileFactory());
    private static final ObjectMapper WRITE_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        Properties arguments = Main.parseArgs(args, LONG_OPT_ARG);
        Main.printArgs(LONG_OPT_ARG, arguments);
        Main.validateNotNullArgs(LONG_OPT_ARG, arguments, ORIENTDB_URL_ARG, EXPORT_DIRECTORY_ARG, REPOSITORY_NAME_ARG);
        Main.validateArgs(arguments);
        Main.orientConnectionPreparation(arguments);
        Instant start = Instant.now();
        String connectionURL = arguments.getProperty(ORIENTDB_URL_ARG);
        String repositoryName = arguments.getProperty(REPOSITORY_NAME_ARG);
        String exportDirectory = arguments.getProperty(EXPORT_DIRECTORY_ARG);
        boolean abbreviatedPackageroot = Main.extractBooleanArgument(arguments, ABBREVIATED_PACKAGEROOT_ARG);
        Throwable throwable = null;
        Object var8_9 = null;
        try (ODatabaseDocumentTx db = (ODatabaseDocumentTx)new ODatabaseDocumentTx(connectionURL).open("admin", "admin");){
            List packageRootResponse = db.query((OQuery)new OSQLSynchQuery("select * from packageroot where repositoryId = ?"), new Object[]{repositoryName});
            for (ODocument oDocument : packageRootResponse) {
                Main.safelyProcessPackageRoot(oDocument, exportDirectory, abbreviatedPackageroot);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Instant end = Instant.now();
        log.info("Process has been finished. Time ~{} seconds.", (Object)TimeUnit.MILLISECONDS.toSeconds(end.toEpochMilli() - start.toEpochMilli()));
    }

    private static boolean extractBooleanArgument(Properties arguments, String argumentKey) {
        String argument = arguments.getProperty(argumentKey);
        if (arguments.containsKey(argumentKey) && StringUtils.isEmpty((CharSequence)argument)) {
            return true;
        }
        return Boolean.parseBoolean(argument);
    }

    private static Properties parseArgs(String[] args, String longOption) throws ParseException {
        Options options = new Options();
        Option propertyOption = Option.builder().longOpt(longOption).argName("property=value").hasArgs().valueSeparator().numberOfArgs(2).build();
        options.addOption(propertyOption);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        return cmd.getOptionProperties(longOption);
    }

    private static void validateNotNullArgs(String longOption, Properties properties, String ... argumentKeys) {
        String[] stringArray = argumentKeys;
        int n = argumentKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String argumentKey = stringArray[n2];
            if (!properties.containsKey(argumentKey)) {
                throw new IllegalArgumentException(String.format("Missing argument. -%s", String.valueOf(longOption) + argumentKey));
            }
            String argumentValue = properties.getProperty(argumentKey);
            if (StringUtils.isBlank((CharSequence)argumentValue)) {
                throw new IllegalArgumentException(String.format("Argument value is required. Actual -%s=%s", String.valueOf(longOption) + argumentKey, argumentValue));
            }
            ++n2;
        }
    }

    private static void validateArgs(Properties properties) throws FileNotFoundException {
        String exportDir = properties.getProperty(EXPORT_DIRECTORY_ARG);
        if (!Files.exists(Paths.get(exportDir, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("Export directory does not exist %s", exportDir));
        }
        if (!Files.isDirectory(Paths.get(exportDir, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("Is not a directory %s", exportDir));
        }
    }

    private static void printArgs(String longOption, Properties properties) {
        for (String argumentKey : properties.stringPropertyNames()) {
            String argumentValue = properties.getProperty(argumentKey);
            log.info("Running with argument -{}={}", (Object)(String.valueOf(longOption) + argumentKey), (Object)argumentValue);
        }
    }

    private static void orientConnectionPreparation(Properties arguments) {
        String dbUrl = arguments.getProperty(ORIENTDB_URL_ARG);
        int index = dbUrl.indexOf(":");
        if (index <= 0) {
            log.info("No found OrientDB engine. Building OrientDB 'plocal' mode.");
            dbUrl = "plocal:" + dbUrl;
            arguments.setProperty(ORIENTDB_URL_ARG, dbUrl);
        }
        if (dbUrl.startsWith("plocal")) {
            System.err.println("\nRunning on Orient 'plocal' mode. Orient 'plocal' mode is a single connection mode.");
            System.err.println(String.format("URL = %s", dbUrl));
            System.err.println("\nRequirements:\n1. Nexus Repository has to shutdown.\n2. OrientDB connection has to have no connections.");
            System.err.println("\nEnter:\n'YES' in case you've done the requirements\n'NO' to exist");
            Throwable throwable = null;
            Object var4_5 = null;
            try (Scanner scanner = new Scanner(System.in);){
                while (true) {
                    String line;
                    if ((line = scanner.nextLine()).equalsIgnoreCase("yes")) {
                        return;
                    }
                    if (!line.equalsIgnoreCase("no")) continue;
                    System.exit(0);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static void safelyProcessPackageRoot(ODocument oDocument, String exportDirectory, boolean isAbbreviatedPackageRoot) {
        String rid = oDocument.field("@rid").toString();
        log.info("Processing {}", (Object)rid);
        try {
            JsonNode packageRoot = Main.extractPackageRoot(oDocument, isAbbreviatedPackageRoot);
            String npmPackageId = (String)oDocument.field(NAME);
            Main.exportPackageRoot(npmPackageId, packageRoot, exportDirectory);
            log.info("Processed {}", (Object)rid);
        }
        catch (Exception e) {
            log.warn("Unable to populate metadata " + rid + ". Continuing.", (Object)e.getMessage(), (Object)e);
        }
    }

    private static JsonNode extractPackageRoot(ODocument oDocument, boolean isAbbreviatedPackageRoot) throws IOException {
        if (isAbbreviatedPackageRoot) {
            return Main.buildAbbreviatedPackageRoot(oDocument);
        }
        return Main.extractFullPackageRoot(oDocument);
    }

    private static ObjectNode extractFullPackageRoot(ODocument oDocument) throws IOException {
        ORecordBytes rawBytes = (ORecordBytes)oDocument.field("raw");
        byte[] rawBytesArray = rawBytes.toStream();
        return (ObjectNode)READ_MAPPER.readValue(rawBytesArray, ObjectNode.class);
    }

    private static JsonNode buildAbbreviatedPackageRoot(ODocument oDocument) throws IOException {
        ObjectNode packageRoot = Main.extractFullPackageRoot(oDocument);
        JsonNode nodeName = Main.requireNonNullJsonNode(packageRoot, NAME);
        JsonNode nodeDistTags = Main.requireNonNullJsonNode(packageRoot, DIST_TAGS);
        ObjectNode result = WRITE_MAPPER.createObjectNode();
        result.set(NAME, nodeName);
        result.set(DIST_TAGS, nodeDistTags);
        return result;
    }

    private static JsonNode requireNonNullJsonNode(ObjectNode source, String jsonNodeKey) {
        JsonNode jsonNode = source.get(jsonNodeKey);
        if (jsonNode == null) {
            throw new IllegalArgumentException(String.format("Json node '%s' is required.", jsonNodeKey));
        }
        return jsonNode;
    }

    private static void exportPackageRoot(String npmPackageId, JsonNode packageRoot, String exportDirectory) throws IOException {
        String json = WRITE_MAPPER.writeValueAsString((Object)packageRoot);
        NpmPackageRootExporter.export(npmPackageId, json, exportDirectory);
    }
}

