/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.search.elasticsearch;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonatype.nexus.cleanup.internal.search.elasticsearch.CriteriaAppender;

public abstract class LessThanTimeCriteriaAppender
implements CriteriaAppender {
    private static final String NOW_MINUS_SECONDS = "now-%ss";
    private final String field;

    public LessThanTimeCriteriaAppender(String field) {
        this.field = field;
    }

    @Override
    public void append(BoolQueryBuilder query, String value) {
        query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)this.field).lte(String.format(NOW_MINUS_SECONDS, value)));
    }
}

