/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.search.elasticsearch;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.search.elasticsearch.CriteriaAppender;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.search.query.RepositoryQueryBuilder;

public abstract class AbstractSearchCleanupComponentBrowse
extends ComponentSupport {
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String GROUP = "group";
    private final ElasticSearchQueryService elasticSearchQueryService;
    private final MetricRegistry metricRegistry;
    private final Map<String, Timer> timers = new ConcurrentHashMap<String, Timer>();
    private final Map<String, CriteriaAppender> criteriaAppenders;

    protected AbstractSearchCleanupComponentBrowse(Map<String, CriteriaAppender> criteriaAppenders, ElasticSearchQueryService elasticSearchQueryService, MetricRegistry metricRegistry) {
        this.criteriaAppenders = (Map)Preconditions.checkNotNull(criteriaAppenders);
        this.elasticSearchQueryService = (ElasticSearchQueryService)Preconditions.checkNotNull((Object)elasticSearchQueryService);
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
    }

    public Stream<EntityId> browse(CleanupPolicy policy, Repository repository) {
        if (policy.getCriteria().isEmpty()) {
            return Stream.empty();
        }
        BoolQueryBuilder query = this.convertPolicyToQuery(policy);
        this.log.debug("Searching for components to cleanup using policy {}", (Object)policy);
        return StreamSupport.stream(this.invokeSearch(policy, repository, (QueryBuilder)query).spliterator(), false).map(searchHit -> new DetachedEntityId(searchHit.getId()));
    }

    private Iterable<SearchHit> invokeSearch(CleanupPolicy policy, Repository repository, QueryBuilder query) {
        long start = System.nanoTime();
        try {
            Iterable iterable = this.elasticSearchQueryService.browse((QueryBuilder)RepositoryQueryBuilder.unrestricted((QueryBuilder)query).inRepositories(new Repository[]{repository}));
            return iterable;
        }
        finally {
            this.updateTimer(policy, repository, System.nanoTime() - start);
        }
    }

    protected SearchResponse invokeSearchByPage(CleanupPolicy policy, Repository repository, QueryOptions options, QueryBuilder query) {
        long start = System.nanoTime();
        try {
            SearchResponse searchResponse = this.elasticSearchQueryService.search((QueryBuilder)RepositoryQueryBuilder.unrestricted((QueryBuilder)query).sortBy(new SortBuilder[]{this.getSort(options.getSortProperty(), options.getSortDirection())}).inRepositories(new Repository[]{repository}), options.getStart().intValue(), options.getLimit().intValue());
            return searchResponse;
        }
        finally {
            this.updateTimer(policy, repository, System.nanoTime() - start);
        }
    }

    private void updateTimer(CleanupPolicy policy, Repository repository, long value) {
        Timer timer = this.timers.computeIfAbsent(String.valueOf(policy.getName()) + "." + repository.getName(), key -> this.metricRegistry.timer(this.getTimerName(policy, repository)));
        timer.update(value, TimeUnit.NANOSECONDS);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Cleanup policy {} search on {} has criteria {} and took {}ms", new Object[]{policy.getName(), repository.getName(), policy.getCriteria(), value});
        }
    }

    private String getTimerName(CleanupPolicy policy, Repository repository) {
        return String.valueOf(((Object)((Object)this)).getClass().getName().replaceAll("\\$.*", "")) + '.' + policy.getName() + "." + repository.getName() + ".timer";
    }

    protected QueryBuilder convertPolicyToQuery(CleanupPolicy policy, QueryOptions options) {
        BoolQueryBuilder queryBuilder = this.convertPolicyToQuery(policy);
        if (Strings.isNullOrEmpty((String)options.getFilter())) {
            return queryBuilder;
        }
        QueryStringQueryBuilder stringQueryBuilder = QueryBuilders.queryStringQuery((String)this.addWildcard(options.getFilter())).field(NAME).field(GROUP).field(VERSION);
        return queryBuilder.must((QueryBuilder)stringQueryBuilder);
    }

    private String addWildcard(String filter) {
        return String.valueOf(filter) + "*";
    }

    private BoolQueryBuilder convertPolicyToQuery(CleanupPolicy policy) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery());
        for (Map.Entry criteria : policy.getCriteria().entrySet()) {
            this.addCriteria(query, (String)criteria.getKey(), (String)criteria.getValue());
        }
        return query;
    }

    private void addCriteria(BoolQueryBuilder query, String key, String value) {
        if (!this.criteriaAppenders.containsKey(key)) {
            throw new UnsupportedOperationException("Criteria of type " + key + " is not supported");
        }
        this.criteriaAppenders.get(key).append(query, value);
    }

    private SortBuilder getSort(String sortProperty, String sortDirection) {
        return SortBuilders.fieldSort((String)sortProperty).order(SortOrder.valueOf((String)sortDirection.toUpperCase()));
    }
}

