/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.rest;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyReleaseType;
import org.sonatype.nexus.cleanup.storage.config.CleanupPolicyAssetNamePattern;
import org.sonatype.nexus.cleanup.storage.config.UniqueCleanupPolicyName;
import org.sonatype.nexus.validation.group.Create;

public class CleanupPolicyXO {
    @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}")
    @UniqueCleanupPolicyName(groups={Create.class})
    @NotEmpty
    @Size(max=255)
    private @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}") @NotEmpty @Size(max=255) String name;
    @NotEmpty
    private String format;
    private String notes;
    private Long criteriaLastBlobUpdated;
    private Long criteriaLastDownloaded;
    private CleanupPolicyReleaseType criteriaReleaseType;
    @CleanupPolicyAssetNamePattern
    private String criteriaAssetRegex;
    private int inUseCount;

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public String getNotes() {
        return this.notes;
    }

    public CleanupPolicyReleaseType getCriteriaReleaseType() {
        return this.criteriaReleaseType;
    }

    public Long getCriteriaLastBlobUpdated() {
        return this.criteriaLastBlobUpdated;
    }

    public Long getCriteriaLastDownloaded() {
        return this.criteriaLastDownloaded;
    }

    public String getCriteriaAssetRegex() {
        return this.criteriaAssetRegex;
    }

    public int getInUseCount() {
        return this.inUseCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setCriteriaAssetRegex(String criteriaAssetRegex) {
        this.criteriaAssetRegex = criteriaAssetRegex;
    }

    public void setCriteriaLastBlobUpdated(Long criteriaLastBlobUpdated) {
        this.criteriaLastBlobUpdated = criteriaLastBlobUpdated;
    }

    public void setCriteriaLastDownloaded(Long criteriaLastDownloaded) {
        this.criteriaLastDownloaded = criteriaLastDownloaded;
    }

    public void setCriteriaReleaseType(CleanupPolicyReleaseType criteriaReleaseType) {
        this.criteriaReleaseType = criteriaReleaseType;
    }

    public void setInUseCount(int inUseCount) {
        this.inUseCount = inUseCount;
    }

    public static CleanupPolicyXO fromCleanupPolicy(CleanupPolicy cleanupPolicy, int inUseCount) {
        CleanupPolicyXO xo = new CleanupPolicyXO();
        xo.setName(cleanupPolicy.getName());
        xo.setFormat(cleanupPolicy.getFormat().equals("ALL_FORMATS") ? "*" : cleanupPolicy.getFormat());
        xo.setNotes(cleanupPolicy.getNotes());
        xo.setCriteriaAssetRegex((String)cleanupPolicy.getCriteria().get("regex"));
        xo.setCriteriaLastBlobUpdated(CleanupPolicyXO.toDays(CleanupPolicyXO.getNullableLong(cleanupPolicy.getCriteria(), "lastBlobUpdated")));
        xo.setCriteriaLastDownloaded(CleanupPolicyXO.toDays(CleanupPolicyXO.getNullableLong(cleanupPolicy.getCriteria(), "lastDownloaded")));
        xo.setCriteriaReleaseType(CleanupPolicyXO.getNullableReleaseType(cleanupPolicy.getCriteria()));
        xo.setInUseCount(inUseCount);
        return xo;
    }

    private static Long getNullableLong(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    private static CleanupPolicyReleaseType getNullableReleaseType(Map<String, String> map) {
        String value = map.get("isPrerelease");
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value) ? CleanupPolicyReleaseType.PRERELEASES : CleanupPolicyReleaseType.RELEASES;
    }

    private static Long toDays(Long seconds) {
        if (seconds == null) {
            return null;
        }
        return TimeUnit.SECONDS.toDays(seconds);
    }
}

