/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.rest;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.config.CleanupPolicyConfiguration;
import org.sonatype.nexus.cleanup.internal.rest.CleanupPolicyFormatXO;
import org.sonatype.nexus.cleanup.internal.rest.CleanupPolicyXO;
import org.sonatype.nexus.cleanup.internal.rest.PreviewRequestXO;
import org.sonatype.nexus.cleanup.preview.CleanupPreviewHelper;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyCriteria;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyPreviewXO;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyReleaseType;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

@Named
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/internal/cleanup-policies")
public class CleanupPolicyResource
extends ComponentSupport
implements Resource {
    private static final int PREVIEW_ITEM_COUNT = 50;
    protected static final String RESOURCE_URI = "/internal/cleanup-policies";
    protected static final String MODE_DELETE = "delete";
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final List<String> formatNames;
    private final List<Format> formats;
    private final Map<String, CleanupPolicyConfiguration> cleanupFormatConfigurationMap;
    private final CleanupPolicyConfiguration defaultCleanupFormatConfiguration;
    private final Provider<CleanupPreviewHelper> cleanupPreviewHelper;
    private final RepositoryManager repositoryManager;

    @Inject
    public CleanupPolicyResource(CleanupPolicyStorage cleanupPolicyStorage, List<Format> formats, Map<String, CleanupPolicyConfiguration> cleanupFormatConfigurationMap, Provider<CleanupPreviewHelper> cleanupPreviewHelper, RepositoryManager repositoryManager) {
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.formats = (List)Preconditions.checkNotNull(formats);
        this.formatNames = formats.stream().map(Format::getValue).collect(Collectors.toList());
        this.formatNames.add("*");
        this.cleanupFormatConfigurationMap = (Map)Preconditions.checkNotNull(cleanupFormatConfigurationMap);
        this.defaultCleanupFormatConfiguration = (CleanupPolicyConfiguration)Preconditions.checkNotNull((Object)cleanupFormatConfigurationMap.get("default"));
        this.cleanupPreviewHelper = (Provider)Preconditions.checkNotNull(cleanupPreviewHelper);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    public List<CleanupPolicyXO> get(@QueryParam(value="format") String format) {
        List policies = StringUtils.isBlank((CharSequence)format) || format.equals("*") ? this.cleanupPolicyStorage.getAll() : this.cleanupPolicyStorage.getAllByFormat(format);
        return policies.stream().map(cleanupPolicy -> CleanupPolicyXO.fromCleanupPolicy(cleanupPolicy, (int)this.repositoryManager.browseForCleanupPolicy(cleanupPolicy.getName()).count())).sorted(Comparator.comparing(CleanupPolicyXO::getName)).collect(Collectors.toList());
    }

    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate(groups={Create.class, Default.class})
    public CleanupPolicyXO add(@Valid CleanupPolicyXO cleanupPolicyXO) {
        if (!this.formatNames.contains(cleanupPolicyXO.getFormat())) {
            throw new ValidationErrorsException("format", "specified format " + cleanupPolicyXO.getFormat() + " is not valid.");
        }
        return CleanupPolicyXO.fromCleanupPolicy(this.cleanupPolicyStorage.add(this.toCleanupPolicy(cleanupPolicyXO)), 0);
    }

    @GET
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public CleanupPolicyXO getByName(@PathParam(value="name") String name) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(name);
        if (cleanupPolicy == null) {
            throw new NotFoundException("Cleanup policy " + name + " not found.");
        }
        return CleanupPolicyXO.fromCleanupPolicy(cleanupPolicy, (int)this.repositoryManager.browseForCleanupPolicy(name).count());
    }

    @PUT
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate(groups={Update.class, Default.class})
    public CleanupPolicyXO edit(@PathParam(value="name") String name, @NotNull @Valid CleanupPolicyXO cleanupPolicyXO) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(name);
        if (cleanupPolicy == null) {
            throw new NotFoundException("Cleanup policy " + cleanupPolicyXO.getName() + " not found.");
        }
        if (!this.formatNames.contains(cleanupPolicyXO.getFormat())) {
            throw new ValidationErrorsException("format", "specified format " + cleanupPolicyXO.getFormat() + " is not valid.");
        }
        cleanupPolicy.setNotes(cleanupPolicyXO.getNotes());
        cleanupPolicy.setFormat(cleanupPolicyXO.getFormat());
        cleanupPolicy.setCriteria(this.toCriteriaMap(cleanupPolicyXO));
        return CleanupPolicyXO.fromCleanupPolicy(this.cleanupPolicyStorage.update(cleanupPolicy), (int)this.repositoryManager.browseForCleanupPolicy(name).count());
    }

    @DELETE
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void delete(@PathParam(value="name") String name) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(name);
        if (cleanupPolicy == null) {
            throw new NotFoundException("Cleanup policy " + name + " not found.");
        }
        this.cleanupPolicyStorage.remove(cleanupPolicy);
    }

    @GET
    @Path(value="criteria/formats")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public List<CleanupPolicyFormatXO> getCriteriaForFormats() {
        ArrayList<CleanupPolicyFormatXO> criteriaByFormat = new ArrayList<CleanupPolicyFormatXO>();
        this.formats.forEach(format -> {
            CleanupPolicyConfiguration config = this.cleanupFormatConfigurationMap.get(format.getValue());
            if (config == null) {
                config = this.defaultCleanupFormatConfiguration;
            }
            criteriaByFormat.add(new CleanupPolicyFormatXO(format.getValue(), format.getValue(), config.getConfiguration().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet())));
        });
        criteriaByFormat.sort(Comparator.comparing(CleanupPolicyFormatXO::getName));
        criteriaByFormat.add(0, new CleanupPolicyFormatXO("*", "All Formats", this.defaultCleanupFormatConfiguration.getConfiguration().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet())));
        return criteriaByFormat;
    }

    @POST
    @Path(value="preview/components")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public PageResult<ComponentXO> previewContent(PreviewRequestXO request) {
        Repository repository = this.repositoryManager.get(request.getRepository());
        if (repository == null) {
            throw new NotFoundException("Repository " + request.getRepository() + " not found.");
        }
        CleanupPolicyPreviewXO xo = new CleanupPolicyPreviewXO();
        xo.setCriteria(new CleanupPolicyCriteria());
        xo.getCriteria().setLastBlobUpdated(request.getCriteriaLastBlobUpdated());
        xo.getCriteria().setLastDownloaded(request.getCriteriaLastDownloaded());
        xo.getCriteria().setReleaseType(request.getCriteriaReleaseType());
        xo.getCriteria().setRegex(request.getCriteriaAssetRegex());
        QueryOptions options = new QueryOptions(request.getFilter(), "name", "asc", Integer.valueOf(0), Integer.valueOf(50));
        try {
            PagedResponse<ComponentXO> response = ((CleanupPreviewHelper)this.cleanupPreviewHelper.get()).getSearchResults(xo, repository, options);
            return new PageResult(response.getTotal(), new ArrayList((Collection)response.getData()));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationErrorsException("filter", e.getMessage());
        }
    }

    private CleanupPolicy toCleanupPolicy(CleanupPolicyXO cleanupPolicyXO) {
        CleanupPolicy policy = this.cleanupPolicyStorage.newCleanupPolicy();
        policy.setName(cleanupPolicyXO.getName());
        policy.setNotes(cleanupPolicyXO.getNotes());
        policy.setMode(MODE_DELETE);
        policy.setFormat(cleanupPolicyXO.getFormat());
        policy.setCriteria(this.toCriteriaMap(cleanupPolicyXO));
        return policy;
    }

    private Map<String, String> toCriteriaMap(CleanupPolicyXO cleanupPolicyXO) {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        CleanupPolicyConfiguration cleanupFormatConfiguration = this.cleanupFormatConfigurationMap.get(cleanupPolicyXO.getFormat());
        if (cleanupFormatConfiguration == null) {
            cleanupFormatConfiguration = this.defaultCleanupFormatConfiguration;
        }
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "regex", cleanupPolicyXO.getCriteriaAssetRegex(), "Asset name regex", cleanupPolicyXO.getFormat());
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "lastBlobUpdated", CleanupPolicyResource.toSeconds(cleanupPolicyXO.getCriteriaLastBlobUpdated()), "Published before", cleanupPolicyXO.getFormat());
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "lastDownloaded", CleanupPolicyResource.toSeconds(cleanupPolicyXO.getCriteriaLastDownloaded()), "Last downloaded before", cleanupPolicyXO.getFormat());
        if (cleanupPolicyXO.getCriteriaReleaseType() != null) {
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "isPrerelease", CleanupPolicyReleaseType.PRERELEASES.equals((Object)cleanupPolicyXO.getCriteriaReleaseType()), "Release type", cleanupPolicyXO.getFormat());
        }
        return criteriaMap;
    }

    private void handleCriteria(CleanupPolicyConfiguration cleanupPolicyConfiguration, Map<String, String> criteriaMap, String key, Object value, String keyText, String format) {
        if (value != null) {
            Boolean val = (Boolean)cleanupPolicyConfiguration.getConfiguration().get(key);
            if (val != null && val.equals(Boolean.TRUE)) {
                criteriaMap.put(key, String.valueOf(value));
            } else {
                throw new BadRequestException("Specified format " + format + " does not support the '" + keyText + "' criteria.");
            }
        }
    }

    private static Long toSeconds(Long days) {
        if (days == null) {
            return null;
        }
        return TimeUnit.DAYS.toSeconds(days);
    }
}

