/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.orient.service;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.orient.search.elasticsearch.OrientCleanupComponentBrowse;
import org.sonatype.nexus.cleanup.preview.CleanupPreviewHelper;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyCriteria;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyPreviewXO;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.DefaultComponentXO;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientCleanupPreviewHelperImpl
extends ComponentSupport
implements CleanupPreviewHelper {
    private static final BiFunction<Component, String, ComponentXO> COMPONENT_CONVERTER = (component, repositoryName) -> {
        DefaultComponentXO defaultComponentXO = new DefaultComponentXO();
        defaultComponentXO.setRepository(repositoryName);
        defaultComponentXO.setGroup(component.group());
        defaultComponentXO.setName(component.name());
        defaultComponentXO.setVersion(component.version());
        defaultComponentXO.setFormat(component.format());
        return defaultComponentXO;
    };
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final OrientCleanupComponentBrowse cleanupComponentBrowse;

    @Inject
    public OrientCleanupPreviewHelperImpl(CleanupPolicyStorage cleanupPolicyStorage, OrientCleanupComponentBrowse cleanupComponentBrowse) {
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.cleanupComponentBrowse = (OrientCleanupComponentBrowse)Preconditions.checkNotNull((Object)cleanupComponentBrowse);
    }

    @Override
    public PagedResponse<ComponentXO> getSearchResults(CleanupPolicyPreviewXO previewXO, Repository repository, QueryOptions queryOptions) {
        CleanupPolicy cleanupPolicy = this.toCleanupPolicy(previewXO);
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            PagedResponse<ComponentXO> pagedResponse = this.searchForComponents(repository, cleanupPolicy, queryOptions);
            return pagedResponse;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Transactional
    protected PagedResponse<ComponentXO> searchForComponents(Repository repository, CleanupPolicy cleanupPolicy, QueryOptions queryOptions) {
        PagedResponse<Component> components = this.cleanupComponentBrowse.browseByPage(cleanupPolicy, repository, queryOptions);
        List componentXOS = ((Collection)components.getData()).stream().map(item -> COMPONENT_CONVERTER.apply((Component)item, repository.getName())).collect(Collectors.toList());
        return new PagedResponse(components.getTotal(), componentXOS);
    }

    private CleanupPolicy toCleanupPolicy(CleanupPolicyPreviewXO cleanupPolicyPreviewXO) {
        CleanupPolicy policy = this.cleanupPolicyStorage.newCleanupPolicy();
        policy.setName("preview");
        policy.setCriteria(CleanupPolicyCriteria.toMap((CleanupPolicyCriteria)cleanupPolicyPreviewXO.getCriteria()));
        return policy;
    }
}

