/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.orient.method;

import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.method.CleanupMethod;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientDeleteCleanupMethod
extends ComponentSupport
implements CleanupMethod {
    private final int batchSize;

    @Inject
    public OrientDeleteCleanupMethod(@Named(value="${nexus.cleanup.batchSize:-100}") int batchSize) {
        this.batchSize = batchSize;
    }

    public DefaultComponentMaintenanceImpl.DeletionProgress run(Repository repository, Stream<EntityId> components, BooleanSupplier cancelledCheck) {
        return ((ComponentMaintenance)repository.facet(ComponentMaintenance.class)).deleteComponents((Iterable)components.collect(Collectors.toList()), cancelledCheck, this.batchSize);
    }
}

