/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.datastore.search.criteria;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.cleanup.internal.datastore.search.criteria.AssetCleanupEvaluator;
import org.sonatype.nexus.cleanup.internal.datastore.search.criteria.LastBlobUpdatedCleanupEvaluator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;

@Named(value="lastDownloaded")
public class LastDownloadedCleanupEvaluator
implements AssetCleanupEvaluator {
    private final LastBlobUpdatedCleanupEvaluator lastBlobUpdatedCleanupCriteria;

    @Inject
    public LastDownloadedCleanupEvaluator(LastBlobUpdatedCleanupEvaluator lastBlobUpdatedCleanupCriteria) {
        this.lastBlobUpdatedCleanupCriteria = (LastBlobUpdatedCleanupEvaluator)Preconditions.checkNotNull((Object)lastBlobUpdatedCleanupCriteria);
    }

    @Override
    public Predicate<Asset> getPredicate(Repository repository, String value) {
        OffsetDateTime cutTime = OffsetDateTime.now().minusSeconds(Long.valueOf(value));
        Predicate<Asset> lastBlobUpdated = this.lastBlobUpdatedCleanupCriteria.getPredicate(repository, value);
        return asset -> asset.lastDownloaded().map(lastDownloaded -> lastDownloaded.isBefore(cutTime) || lastDownloaded.isEqual(cutTime)).orElseGet(() -> lastBlobUpdated.test((Asset)asset));
    }
}

