/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.datastore.search.criteria;

import java.time.OffsetDateTime;
import java.util.function.Predicate;
import javax.inject.Named;
import org.sonatype.nexus.cleanup.internal.datastore.search.criteria.AssetCleanupEvaluator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;

@Named(value="lastBlobUpdated")
public class LastBlobUpdatedCleanupEvaluator
implements AssetCleanupEvaluator {
    @Override
    public Predicate<Asset> getPredicate(Repository repository, String value) {
        OffsetDateTime cutTime = OffsetDateTime.now().minusSeconds(Long.valueOf(value));
        return asset -> {
            OffsetDateTime blobCreated = asset.blob().map(AssetBlob::blobCreated).orElse(null);
            return blobCreated != null && (blobCreated.isBefore(cutTime) || blobCreated.isEqual(cutTime));
        };
    }
}

