/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.content.service;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.content.search.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.preview.CleanupPreviewHelper;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyCriteria;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyPreviewXO;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.DefaultComponentXO;

@Named
@Singleton
public class CleanupPreviewHelperImpl
extends ComponentSupport
implements CleanupPreviewHelper {
    private static final BiFunction<Component, Repository, ComponentXO> COMPONENT_CONVERTER = (component, repository) -> {
        DefaultComponentXO defaultComponentXO = new DefaultComponentXO();
        defaultComponentXO.setRepository(repository.getName());
        defaultComponentXO.setGroup(component.namespace());
        defaultComponentXO.setName(component.name());
        defaultComponentXO.setVersion(component.version());
        defaultComponentXO.setFormat(repository.getFormat().getValue());
        return defaultComponentXO;
    };
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final CleanupComponentBrowse cleanupComponentBrowse;

    @Inject
    public CleanupPreviewHelperImpl(CleanupPolicyStorage cleanupPolicyStorage, CleanupComponentBrowse cleanupComponentBrowse) {
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.cleanupComponentBrowse = (CleanupComponentBrowse)Preconditions.checkNotNull((Object)cleanupComponentBrowse);
    }

    @Override
    public PagedResponse<ComponentXO> getSearchResults(CleanupPolicyPreviewXO previewXO, Repository repository, QueryOptions queryOptions) {
        CleanupPolicy cleanupPolicy = this.toCleanupPolicy(previewXO);
        return this.searchForComponents(repository, cleanupPolicy, queryOptions);
    }

    private PagedResponse<ComponentXO> searchForComponents(Repository repository, CleanupPolicy cleanupPolicy, QueryOptions queryOptions) {
        PagedResponse<Component> components = this.cleanupComponentBrowse.browseByPage(cleanupPolicy, repository, queryOptions);
        List componentXOS = ((Collection)components.getData()).stream().map(item -> COMPONENT_CONVERTER.apply((Component)item, repository)).collect(Collectors.toList());
        return new PagedResponse(components.getTotal(), componentXOS);
    }

    private CleanupPolicy toCleanupPolicy(CleanupPolicyPreviewXO cleanupPolicyPreviewXO) {
        CleanupPolicy policy = this.cleanupPolicyStorage.newCleanupPolicy();
        policy.setName("preview");
        policy.setCriteria(CleanupPolicyCriteria.toMap((CleanupPolicyCriteria)cleanupPolicyPreviewXO.getCriteria()));
        return policy;
    }
}

