/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.internal.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagStore;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import com.sonatype.nexus.tags.service.TagService;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobStoreUtil;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentAttributes;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.InternalIds;

@Named(value="mybatis")
@Singleton
public class DatastoreStagingComponentManager
extends ComponentSupport {
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreUtil blobStoreUtil;
    private final ComponentTagStoreManager componentTagStoreManager;
    private final int tagLimit;
    private final TagService tagService;
    private final TagStore tagStore;

    @Inject
    public DatastoreStagingComponentManager(BlobStoreManager blobStoreManager, BlobStoreUtil blobStoreUtil, ComponentTagStoreManager componentTagStoreManager, @Named(value="${nexus.export.browseTagsLimit:-1000}") int tagLimit, TagService tagService, TagStore tagStore) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.blobStoreUtil = (BlobStoreUtil)Preconditions.checkNotNull((Object)blobStoreUtil);
        this.componentTagStoreManager = (ComponentTagStoreManager)Preconditions.checkNotNull((Object)componentTagStoreManager);
        this.tagLimit = (Integer)Preconditions.checkNotNull((Object)tagLimit);
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
    }

    protected Component move(ContentDirector contentDirector, Component originalComponent, Repository source, Repository destination) {
        Map.Entry<Component, List<Asset>> entry = this.getComponentAssets(source, originalComponent);
        this.log.debug("Moving {{}}, from '{}' to '{}'", new Object[]{entry.getKey().toStringExternal(), source.getName(), destination.getName()});
        List<Asset> assets = entry.getValue();
        Component component = contentDirector.beforeMove(originalComponent, assets, source, destination);
        ComponentTagStore storeForRepository = this.componentTagStoreManager.getStoreForRepository(source);
        Continuation componentTags = storeForRepository.browseComponentTags(component, this.tagLimit, null);
        List tags = this.tagStore.getByIds(componentTags.stream().map(ComponentTag::getTagId).collect(Collectors.toSet()));
        ((ContentMaintenanceFacet)source.facet(ContentMaintenanceFacet.class)).deleteComponent(component);
        Component newComponent = this.doMove(contentDirector, destination, component, assets);
        tags.forEach(tag -> {
            List list = this.tagService.associateById(tag.name(), destination, InternalIds.toExternalId((int)InternalIds.internalComponentId((Component)newComponent)));
        });
        tags.forEach(tag -> storeForRepository.deleteComponentTag(component, tag));
        return contentDirector.afterMove(newComponent, destination);
    }

    protected void verifyMove(ContentDirector contentDirector, FluentComponent component, Repository destination) {
        if (!contentDirector.allowMoveTo(component, destination)) {
            throw new MoveNotAllowedException("Move not supported for component: " + component);
        }
        if (this.componentExists((Component)component, destination) && !this.redeployAllowed(destination)) {
            throw new MoveNotAllowedException("Destination already contains component: " + component);
        }
    }

    protected Map.Entry<Component, List<Asset>> getComponentAssets(Repository repository, Component component) {
        ContentFacet content = (ContentFacet)repository.facet(ContentFacet.class);
        return Optional.of(component).map(c -> new AbstractMap.SimpleEntry((Component)c, new ArrayList(content.components().with(c).assets()))).orElse(null);
    }

    protected boolean componentExists(Component component, Repository repository) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).components().name(component.name()).namespace(component.namespace()).version(component.version()).find().isPresent();
    }

    private boolean redeployAllowed(Repository repository) {
        return WritePolicy.ALLOW.name().equals(repository.getConfiguration().attributes("storage").get("writePolicy"));
    }

    protected Component doMove(ContentDirector contentDirector, Repository destination, Component source, List<Asset> assets) {
        FluentComponent destComponent = contentDirector.copyComponent(source, destination);
        this.moveAssets(destination, assets, destComponent);
        return destComponent;
    }

    private void moveAssets(Repository destination, List<Asset> assets, FluentComponent destComponent) {
        ContentFacet content = (ContentFacet)destination.facet(ContentFacet.class);
        assets.forEach(asset -> {
            FluentAssetBuilder destAssetBuilder = content.assets().path(asset.path()).kind(asset.kind()).component((Component)destComponent);
            Optional assetBlob = asset.blob();
            FluentAsset destAsset = assetBlob.map(blob -> destAssetBuilder.blob(this.moveBlob((AssetBlob)blob, destination), this.blobStoreUtil.toHashObjects(blob.checksums()))).map(FluentAssetBuilder::save).orElseGet(() -> ((FluentAssetBuilder)destAssetBuilder).save());
            assetBlob.ifPresent(blob -> destAsset.blobCreated(blob.blobCreated()));
            asset.attributes().forEach(attribute -> {
                FluentAttributes fluentAttributes = destAsset.withAttribute((String)attribute.getKey(), attribute.getValue());
            });
            this.log.debug("Moved asset {} to repository {}", (Object)destAsset.path(), (Object)destination.getName());
        });
    }

    private String blobStoreNameOf(Repository repository, String failureMessage) {
        return Optional.of(repository).map(Repository::getConfiguration).map(c -> c.attributes("storage")).map(a -> (String)a.get("blobStoreName", String.class)).orElseThrow(() -> new IllegalStateException(String.format(failureMessage, repository.getName())));
    }

    private BlobStore blobStoreOf(String blobStoreName, String failureMessage) {
        return Optional.of(blobStoreName).map(arg_0 -> ((BlobStoreManager)this.blobStoreManager).get(arg_0)).orElseThrow(() -> new IllegalStateException(String.format(failureMessage, blobStoreName)));
    }

    private InputStream inputStreamOf(BlobStore blobStore, BlobRef blobRef, String failureMessage) {
        return Optional.of(blobRef).map(BlobRef::getBlobId).map(r -> blobStore.get(r, true)).map(Blob::getInputStream).orElseThrow(() -> new IllegalStateException(String.format(failureMessage, blobRef)));
    }

    private Blob moveBlob(AssetBlob srcBlob, Repository destRepo) {
        Preconditions.checkNotNull((Object)srcBlob);
        Preconditions.checkNotNull((Object)destRepo);
        BlobRef srcBlobRef = srcBlob.blobRef();
        String destBlobStoreName = this.blobStoreNameOf(destRepo, "Unable to find blob store name for destination repository: %s");
        String srcBlobStoreName = srcBlobRef.getStore();
        BlobStore srcBlobStore = this.blobStoreOf(srcBlobStoreName, "Unable to find source blob store: %s");
        if (destBlobStoreName.equals(srcBlobStoreName)) {
            BlobAttributes blobAttributes = srcBlobStore.getBlobAttributes(srcBlobRef.getBlobId());
            blobAttributes.setDeleted(false);
            blobAttributes.setDeletedReason(null);
            blobAttributes.getHeaders().put("Bucket.repo-name", destRepo.getName());
            srcBlobStore.setBlobAttributes(srcBlobRef.getBlobId(), blobAttributes);
            return srcBlobStore.get(srcBlobRef.getBlobId());
        }
        BlobStore destBlobStore = this.blobStoreOf(destBlobStoreName, "Unable to find destination blob store: %s");
        BlobAttributes blobAttributes = srcBlobStore.getBlobAttributes(srcBlobRef.getBlobId());
        blobAttributes.getHeaders().put("Bucket.repo-name", destRepo.getName());
        InputStream srcInputStream = this.inputStreamOf(srcBlobStore, srcBlobRef, "Unable to get input stream for source blob ref: %s");
        Blob blob = destBlobStore.create(srcInputStream, blobAttributes.getHeaders());
        srcBlobStore.deleteHard(srcBlobRef.getBlobId());
        return blob;
    }

    static class ComponentToMoveNotFoundException
    extends RuntimeException {
        ComponentToMoveNotFoundException(EntityId componentId) {
            super("Unable to find component by id: " + componentId);
        }
    }

    static class MoveNotAllowedException
    extends RuntimeException {
        MoveNotAllowedException(String message) {
            super(message);
        }
    }
}

