/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.codahale.metrics.health.HealthCheck;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.SortedMap;
import javax.ws.rs.GET;
import javax.ws.rs.core.Response;

@Api(value="Status")
public interface StatusResourceDoc {
    @GET
    @ApiOperation(value="Health check endpoint that validates server can respond to read requests")
    @ApiResponses(value={@ApiResponse(code=200, message="Available to service requests"), @ApiResponse(code=503, message="Unavailable to service requests")})
    public Response isAvailable();

    @GET
    @ApiOperation(value="Health check endpoint that validates server can respond to read and write requests")
    @ApiResponses(value={@ApiResponse(code=200, message="Available to service requests"), @ApiResponse(code=503, message="Unavailable to service requests")})
    public Response isWritable();

    @GET
    @ApiOperation(value="Health check endpoint that returns the results of the system status checks")
    @ApiResponses(value={@ApiResponse(code=200, message="The system status check results", response=HealthCheck.Result.class, responseContainer="Map")})
    public SortedMap<String, HealthCheck.Result> getSystemStatusChecks();
}

