/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FreezeRequest;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.internal.status.HealthCheckComponentSupport;

@Named(value="Read-Only Detector")
@Singleton
public class ReadOnlyHealthCheck
extends HealthCheckComponentSupport {
    private final FreezeService freezeService;

    @Inject
    public ReadOnlyHealthCheck(FreezeService freezeService) {
        this.freezeService = (FreezeService)Preconditions.checkNotNull((Object)freezeService);
    }

    protected HealthCheck.Result check() {
        return this.freezeService.currentFreezeRequests().stream().findFirst().map(this::describe).map(HealthCheck.Result::unhealthy).orElse(HealthCheck.Result.healthy());
    }

    private String describe(FreezeRequest request) {
        String description = "Made read-only by: " + request.frozenBy().orElse("SYSTEM");
        if (!Strings2.isBlank((String)request.reason())) {
            description = String.valueOf(description) + ", reason: " + request.reason();
        }
        return description;
    }
}

