/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.codahale.metrics.health.HealthCheck;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.system.FileDescriptorService;
import org.sonatype.nexus.internal.status.HealthCheckComponentSupport;

@Named(value="File Descriptors")
@Singleton
public class FileDescriptorHealthCheck
extends HealthCheckComponentSupport {
    private FileDescriptorService fileDescriptorService;

    @Inject
    public FileDescriptorHealthCheck(FileDescriptorService fileDescriptorService) {
        this.fileDescriptorService = fileDescriptorService;
    }

    protected HealthCheck.Result check() {
        return this.fileDescriptorService.isFileDescriptorLimitOk() ? HealthCheck.Result.healthy() : HealthCheck.Result.unhealthy((String)this.reason());
    }

    private String reason() {
        return String.format("Recommended file descriptor limit is %d but count is %d", this.fileDescriptorService.getFileDescriptorRecommended(), this.fileDescriptorService.getFileDescriptorCount());
    }
}

