/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.status.HealthCheckComponentSupport;

@Named(value="Available CPUs")
@Singleton
public class AvailableCpuHealthCheck
extends HealthCheckComponentSupport {
    static final int MIN_RECOMMENDED_CPU_COUNT = 4;
    private static final String HEALTHY_MESSAGE = "The host system is allocating a maximum of %d cores to the application.";
    private static final String UNHEALTHY_MESSAGE = "The host system is allocating a maximum of %d cores to the application. A minimum of %d is recommended.";
    private int minCpuCount;

    public AvailableCpuHealthCheck() {
        this(4);
    }

    @VisibleForTesting
    AvailableCpuHealthCheck(int minCpuCount) {
        this.minCpuCount = minCpuCount;
    }

    private Runtime getRuntime() {
        return Runtime.getRuntime();
    }

    protected HealthCheck.Result check() {
        int available = this.getRuntime().availableProcessors();
        if (this.minCpuCount > available) {
            return HealthCheck.Result.unhealthy((String)UNHEALTHY_MESSAGE, (Object[])new Object[]{available, this.minCpuCount});
        }
        return HealthCheck.Result.healthy((String)HEALTHY_MESSAGE, (Object[])new Object[]{available});
    }
}

