/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.ssl;

import com.google.common.base.Throwables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.ssl.CertificateCreatedEvent;
import org.sonatype.nexus.ssl.CertificateDeletedEvent;
import org.sonatype.nexus.ssl.CertificateEvent;

@Named
@Singleton
public class SslCertificateAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "security.sslcertificate";

    public SslCertificateAuditor() {
        this.registerType(CertificateCreatedEvent.class, "created");
        this.registerType(CertificateDeletedEvent.class, "deleted");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CertificateEvent event) {
        if (this.isRecording()) {
            Certificate certificate = event.getCertificate();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            Map attributes = data.getAttributes();
            attributes.put("alias", event.getAlias());
            attributes.put("type", certificate.getType());
            if (certificate instanceof X509Certificate) {
                X509Certificate x509 = (X509Certificate)certificate;
                Map<String, String> rdns = SslCertificateAuditor.parseLdapName(x509.getSubjectX500Principal().getName());
                data.setContext(rdns.get("CN"));
                attributes.putAll(rdns);
            } else {
                data.setContext(event.getAlias());
            }
            this.record(data);
        }
    }

    private static Map<String, String> parseLdapName(String dn) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            LdapName ldapName = new LdapName(dn);
            for (Rdn rdn : ldapName.getRdns()) {
                result.put(rdn.getType(), rdn.getValue().toString());
            }
            return result;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

