/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.distributed.event.service.api.DistributedEvent;
import org.sonatype.nexus.distributed.event.service.api.EventType;
import org.sonatype.nexus.distributed.event.service.api.common.PublisherEvent;
import org.sonatype.nexus.distributed.event.service.api.common.SelectorConfigurationChangedEvent;
import org.sonatype.nexus.internal.selector.SelectorConfigurationDAO;
import org.sonatype.nexus.internal.selector.SelectorConfigurationData;
import org.sonatype.nexus.internal.selector.SelectorConfigurationEvent;
import org.sonatype.nexus.internal.selector.SelectorConfigurationStore;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class SelectorConfigurationStoreImpl
extends ConfigStoreSupport<SelectorConfigurationDAO>
implements SelectorConfigurationStore {
    private final EventManager eventManager;

    @Inject
    public SelectorConfigurationStoreImpl(DataSessionSupplier sessionSupplier, EventManager eventManager) {
        super(sessionSupplier);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public SelectorConfiguration newSelectorConfiguration() {
        return new SelectorConfigurationData();
    }

    @Override
    @Transactional
    public List<SelectorConfiguration> browse() {
        return ImmutableList.copyOf((Iterable)((SelectorConfigurationDAO)this.dao()).browse());
    }

    @Override
    public void create(SelectorConfiguration configuration) {
        this.doCreate(configuration);
        this.postEvent(configuration);
        this.postDesEvent(EventType.CREATED);
    }

    @Transactional
    protected void doCreate(SelectorConfiguration configuration) {
        ((SelectorConfigurationDAO)this.dao()).create((SelectorConfigurationData)configuration);
    }

    @Override
    public SelectorConfiguration read(EntityId entityId) {
        throw new UnsupportedOperationException("Use getByName instead");
    }

    @Override
    public void update(SelectorConfiguration configuration) {
        if (this.doUpdate(configuration)) {
            this.postEvent(configuration);
            this.postDesEvent(EventType.UPDATED);
        }
    }

    @Transactional
    protected boolean doUpdate(SelectorConfiguration configuration) {
        return ((SelectorConfigurationDAO)this.dao()).update((SelectorConfigurationData)configuration);
    }

    @Override
    public void delete(SelectorConfiguration configuration) {
        if (this.doDelete(configuration)) {
            this.postEvent(configuration);
            this.postDesEvent(EventType.DELETED);
        }
    }

    @Transactional
    protected boolean doDelete(SelectorConfiguration configuration) {
        return ((SelectorConfigurationDAO)this.dao()).delete(configuration.getName());
    }

    @Override
    @Transactional
    public SelectorConfiguration getByName(String name) {
        return ((SelectorConfigurationDAO)this.dao()).read(name).orElse(null);
    }

    private void postEvent(final SelectorConfiguration configuration) {
        this.eventManager.post((Object)new SelectorConfigurationEvent(){

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public SelectorConfiguration getSelectorConfiguration() {
                return configuration;
            }
        });
    }

    private void postDesEvent(EventType eventType) {
        this.eventManager.post((Object)new PublisherEvent((DistributedEvent)new SelectorConfigurationChangedEvent(eventType)));
    }
}

