/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.io.ObjectInputStreamWithClassLoader;
import org.sonatype.nexus.internal.security.apikey.orient.OrientApiKey;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.BrowseEntitiesByPropertyAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntitiesAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;

@Named
@Singleton
public class OrientApiKeyEntityAdapter
extends IterableEntityAdapter<OrientApiKey> {
    private static final String DB_CLASS = new OClassNameBuilder().type("api_key").build();
    private static final String P_DOMAIN = "domain";
    private static final String P_APIKEY = "api_key";
    private static final String P_PRIMARY_PRINCIPAL = "primary_principal";
    private static final String P_PRINCIPALS = "principals";
    private static final String I_APIKEY = new OIndexNameBuilder().type(DB_CLASS).property("domain").property("api_key").build();
    private static final String I_PRIMARY_PRINCIPAL = new OIndexNameBuilder().type(DB_CLASS).property("domain").property("primary_principal").build();
    private final DeleteEntitiesAction deleteAll = new DeleteEntitiesAction((EntityAdapter)this);
    private final BrowseEntitiesByPropertyAction<OrientApiKey> browseByPrimaryPrincipal = new BrowseEntitiesByPropertyAction((IterableEntityAdapter)this, new String[]{"primary_principal"});
    private final ReadEntityByPropertyAction<OrientApiKey> findByApiKey = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"domain", "api_key"});
    private final ClassLoader uberClassLoader;

    @Inject
    public OrientApiKeyEntityAdapter(@Named(value="nexus-uber") ClassLoader uberClassLoader) {
        super(DB_CLASS);
        this.uberClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)uberClassLoader);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        super.defineType(db, type);
        this.enableRecordEncryption(db, type);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_APIKEY, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_DOMAIN, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_PRIMARY_PRINCIPAL, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_PRINCIPALS, OType.BINARY).setMandatory(true).setNotNull(true);
        type.createIndex(I_APIKEY, OClass.INDEX_TYPE.UNIQUE, new String[]{P_DOMAIN, P_APIKEY});
        type.createIndex(I_PRIMARY_PRINCIPAL, OClass.INDEX_TYPE.UNIQUE, new String[]{P_DOMAIN, P_PRIMARY_PRINCIPAL});
    }

    protected OrientApiKey newEntity() {
        return new OrientApiKey();
    }

    protected void readFields(ODocument document, OrientApiKey entity) {
        String domain = (String)document.field(P_DOMAIN, OType.STRING);
        String apiKey = (String)document.field(P_APIKEY, OType.STRING);
        PrincipalCollection principals = (PrincipalCollection)this.deserialize(document, P_PRINCIPALS);
        entity.setDomain(domain);
        entity.setApiKey(apiKey.toCharArray());
        entity.setPrincipals(principals);
    }

    private Object deserialize(ODocument document, String fieldName) {
        byte[] bytes = (byte[])document.field(fieldName, OType.BINARY);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ObjectInputStreamWithClassLoader objects = new ObjectInputStreamWithClassLoader((InputStream)new ByteArrayInputStream(bytes), this.uberClassLoader);){
                return objects.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeFields(ODocument document, OrientApiKey entity) {
        document.field(P_DOMAIN, (Object)entity.getDomain());
        document.field(P_APIKEY, (Object)String.valueOf(entity.getApiKey()));
        document.field(P_PRIMARY_PRINCIPAL, (Object)entity.getPrincipals().getPrimaryPrincipal().toString());
        document.field(P_PRINCIPALS, (Object)this.serialize(entity.getPrincipals()));
    }

    private byte[] serialize(Object object) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
                ObjectOutputStream objects = new ObjectOutputStream(bytes);
                objects.writeObject(object);
                objects.flush();
                return bytes.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAll(ODatabaseDocumentTx db) {
        this.deleteAll.execute(db);
    }

    public Iterable<OrientApiKey> browseByPrimaryPrincipal(ODatabaseDocumentTx db, Object value) {
        return this.browseByPrimaryPrincipal.execute(db, new Object[]{value});
    }

    @Nullable
    public OrientApiKey findByApiKey(ODatabaseDocumentTx db, String domain, char[] apiKey) {
        Preconditions.checkNotNull((Object)domain);
        Preconditions.checkNotNull((Object)apiKey);
        return (OrientApiKey)this.findByApiKey.execute(db, new Object[]{domain, String.valueOf(apiKey)});
    }
}

