/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.internal.security.apikey.ApiKeyDAO;
import org.sonatype.nexus.internal.security.apikey.ApiKeyData;
import org.sonatype.nexus.internal.security.apikey.ApiKeyToken;
import org.sonatype.nexus.internal.security.apikey.DefaultApiKeyFactory;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.security.UserPrincipalsExpired;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyFactory;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.transaction.Transactional;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="mybatis")
@Singleton
public class ApiKeyStoreImpl
extends ConfigStoreSupport<ApiKeyDAO>
implements ApiKeyStore,
EventAware {
    private final UserPrincipalsHelper principalsHelper;
    private final Map<String, ApiKeyFactory> apiKeyFactories;
    private final DefaultApiKeyFactory defaultApiKeyFactory;

    @Inject
    public ApiKeyStoreImpl(DataSessionSupplier sessionSupplier, UserPrincipalsHelper principalsHelper, Map<String, ApiKeyFactory> apiKeyFactories, DefaultApiKeyFactory defaultApiKeyFactory) {
        super(sessionSupplier);
        this.principalsHelper = (UserPrincipalsHelper)Preconditions.checkNotNull((Object)principalsHelper);
        this.apiKeyFactories = (Map)Preconditions.checkNotNull(apiKeyFactories);
        this.defaultApiKeyFactory = (DefaultApiKeyFactory)((Object)Preconditions.checkNotNull((Object)((Object)defaultApiKeyFactory)));
    }

    public char[] createApiKey(String domain, PrincipalCollection principals) {
        char[] apiKey = this.makeApiKey(domain, principals);
        this.persistApiKey(domain, principals, apiKey);
        return apiKey;
    }

    private char[] makeApiKey(String domain, PrincipalCollection principals) {
        ApiKeyFactory factory = this.apiKeyFactories.get(domain);
        if (factory != null) {
            return (char[])Preconditions.checkNotNull((Object)factory.makeApiKey(principals));
        }
        return this.defaultApiKeyFactory.makeApiKey(principals);
    }

    @Transactional
    public void persistApiKey(String domain, PrincipalCollection principals, char[] apiKey) {
        ApiKeyData apiKeyData = new ApiKeyData();
        apiKeyData.setDomain(domain);
        apiKeyData.setPrincipals(principals);
        apiKeyData.setApiKey(apiKey);
        ((ApiKeyDAO)this.dao()).save(apiKeyData);
    }

    @Transactional
    public char[] getApiKey(String domain, PrincipalCollection principals) {
        return ((ApiKeyDAO)this.dao()).findApiKey(domain, principals.getPrimaryPrincipal().toString()).map(ApiKeyToken::getChars).orElse(null);
    }

    @Transactional
    public PrincipalCollection getPrincipals(String domain, char[] apiKey) {
        return ((ApiKeyDAO)this.dao()).findPrincipals(domain, new ApiKeyToken(apiKey)).orElse(null);
    }

    @Transactional
    public void deleteApiKey(String domain, PrincipalCollection principals) {
        ((ApiKeyDAO)this.dao()).deleteDomainKey(domain, principals.getPrimaryPrincipal().toString());
    }

    @Transactional
    public void deleteApiKeys(PrincipalCollection principals) {
        ((ApiKeyDAO)this.dao()).deleteKeys(principals.getPrimaryPrincipal().toString());
    }

    @Transactional
    public void deleteApiKeys() {
        ((ApiKeyDAO)this.dao()).deleteAllKeys();
    }

    public void purgeApiKeys() {
        CancelableHelper.checkCancellation();
        ArrayList candidates = Lists.newArrayList(this.doBrowsePrincipals());
        Iterator itr = candidates.iterator();
        while (itr.hasNext()) {
            CancelableHelper.checkCancellation();
            if (!this.userExists((PrincipalCollection)itr.next())) continue;
            itr.remove();
        }
        for (PrincipalCollection principals : candidates) {
            CancelableHelper.checkCancellation();
            this.deleteApiKeys(principals);
        }
    }

    @Transactional
    protected Iterable<PrincipalCollection> doBrowsePrincipals() {
        return ((ApiKeyDAO)this.dao()).browsePrincipals();
    }

    protected boolean userExists(PrincipalCollection principals) {
        try {
            this.principalsHelper.getUserStatus(principals);
            return true;
        }
        catch (UserNotFoundException e) {
            this.log.debug("Stale user found", (Throwable)e);
            return false;
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(UserPrincipalsExpired event) {
        String userId = event.getUserId();
        if (userId != null) {
            this.deleteApiKeys((PrincipalCollection)new SimplePrincipalCollection((Object)userId, event.getSource()));
        } else {
            this.purgeApiKeys();
        }
    }
}

