/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.script.groovy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.File;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptEngine;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.script.ScriptCleanupHandler;
import org.sonatype.nexus.internal.script.ScriptTask;
import org.sonatype.nexus.internal.script.groovy.GroovyScriptEngine;

@Named(value="groovy")
@Singleton
public class GroovyScriptEngineFactory
extends org.codehaus.groovy.jsr223.GroovyScriptEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(GroovyScriptEngineFactory.class);
    private final ClassLoader classLoader;
    private final ApplicationDirectories applicationDirectories;
    private GroovyScriptEngine engine;

    @Inject
    public GroovyScriptEngineFactory(@Named(value="nexus-uber") ClassLoader classLoader, ApplicationDirectories applicationDirectories) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    private GroovyScriptEngine create() {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setTargetDirectory(new File(this.applicationDirectories.getTemporaryDirectory(), "groovy-classes"));
        cc.setSourceEncoding("UTF-8");
        cc.setScriptBaseClass(ScriptWithCleanup.class.getName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{this.secureASTCustomizer()});
        GroovyClassLoader gcl = new GroovyClassLoader(this.classLoader, cc);
        this.engine = new GroovyScriptEngine(gcl);
        log.info("Created engine: {}", (Object)this.engine);
        return this.engine;
    }

    private CompilationCustomizer secureASTCustomizer() {
        SecureASTCustomizer secureASTCustomizer = new SecureASTCustomizer();
        secureASTCustomizer.setImportsBlacklist(Collections.singletonList("java.lang.System"));
        secureASTCustomizer.setReceiversBlackList(Collections.singletonList(System.class.getName()));
        secureASTCustomizer.setIndirectImportCheckEnabled(true);
        return secureASTCustomizer;
    }

    public synchronized ScriptEngine getScriptEngine() {
        if (this.engine == null) {
            this.engine = this.create();
        }
        return this.engine;
    }

    @VisibleForTesting
    static String getContext(Binding binding) {
        Optional<String> taskContext = GroovyScriptEngineFactory.getVariable(binding, "task", ScriptTask.class).map(ts -> String.format("Task '%s'", ts.getName()));
        Optional<String> scriptContext = GroovyScriptEngineFactory.getVariable(binding, "scriptName", String.class).map(name -> String.format("Script '%s'", name));
        return Stream.of(taskContext, scriptContext).filter(Optional::isPresent).map(Optional::get).findFirst().orElse("An unknown script");
    }

    private static <T> Optional<T> getVariable(Binding binding, String name, Class<T> type) {
        Object instance;
        if (binding.hasVariable(name) && type.isInstance(instance = binding.getVariable(name))) {
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public static abstract class ScriptWithCleanup
    extends Script {
        public Object run() {
            try {
                Object object = this.scriptBody();
                return object;
            }
            finally {
                Object scriptCleanupHelper = this.getBinding().getVariable("scriptCleanupHandler");
                if (scriptCleanupHelper instanceof ScriptCleanupHandler) {
                    ((ScriptCleanupHandler)scriptCleanupHelper).cleanup(GroovyScriptEngineFactory.getContext(this.getBinding()));
                }
            }
        }

        protected abstract Object scriptBody();
    }
}

