/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.script;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.common.script.ScriptService;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class ScriptTask
extends TaskSupport {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final ScriptService scripts;
    private String source;

    @Inject
    public ScriptTask(ScriptService scripts) {
        this.scripts = (ScriptService)Preconditions.checkNotNull((Object)scripts);
    }

    public void configure(TaskConfiguration configuration) {
        super.configure(configuration);
        this.source = configuration.getString("source");
    }

    public String getMessage() {
        return messages.message();
    }

    protected Object execute() throws Exception {
        this.log.debug("Executing script");
        ImmutableMap customBindings = ImmutableMap.builder().put((Object)"log", (Object)LoggerFactory.getLogger(ScriptTask.class)).put((Object)"task", (Object)this).build();
        this.log.debug("Evaluating source: {}", (Object)this.source);
        Object result = this.scripts.eval(this.getConfiguration().getString("language"), this.source, (Map)customBindings);
        this.log.trace("Result: {}", result);
        return result;
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Execute script")
        public String message();
    }
}

