/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.scheduling;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.events.TaskDeletedEvent;
import org.sonatype.nexus.scheduling.events.TaskEvent;
import org.sonatype.nexus.scheduling.events.TaskEventCanceled;
import org.sonatype.nexus.scheduling.events.TaskEventStarted;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedCanceled;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedDone;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedFailed;
import org.sonatype.nexus.scheduling.events.TaskScheduledEvent;

@Named
@Singleton
public class TaskAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "tasks";

    public TaskAuditor() {
        this.registerType(TaskScheduledEvent.class, "scheduled");
        this.registerType(TaskEventStarted.class, "started");
        this.registerType(TaskEventStoppedDone.class, "finished");
        this.registerType(TaskEventStoppedFailed.class, "failed");
        this.registerType(TaskEventCanceled.class, "cancel-requested");
        this.registerType(TaskEventStoppedCanceled.class, "canceled");
        this.registerType(TaskDeletedEvent.class, "deleted");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskEvent event) {
        if (this.isRecording()) {
            TaskInfo task = event.getTaskInfo();
            TaskConfiguration configuration = task.getConfiguration();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(configuration.getTypeName());
            Map attributes = data.getAttributes();
            attributes.put("schedule", TaskAuditor.string((Object)task.getSchedule()));
            attributes.put("currentState", TaskAuditor.string((Object)task.getCurrentState()));
            attributes.put("lastRunState", TaskAuditor.string((Object)task.getLastRunState()));
            attributes.putAll(configuration.asMap());
            this.record(data);
        }
    }
}

