/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.scheduling;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.internal.scheduling.SchedulerCapabilityConfiguration;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Named(value="scheduling.scheduler")
public class SchedulerCapability
extends CapabilitySupport<SchedulerCapabilityConfiguration> {
    private final SchedulerSPI scheduler;
    private boolean pausedByUs = false;

    @Inject
    public SchedulerCapability(SchedulerSPI scheduler) {
        this.scheduler = (SchedulerSPI)Preconditions.checkNotNull((Object)scheduler);
    }

    protected SchedulerCapabilityConfiguration createConfig(Map<String, String> properties) throws Exception {
        return new SchedulerCapabilityConfiguration(properties);
    }

    protected void onActivate(SchedulerCapabilityConfiguration config) throws Exception {
        if (this.pausedByUs) {
            this.pausedByUs = false;
            this.scheduler.resume();
        }
    }

    protected void onPassivate(SchedulerCapabilityConfiguration config) throws Exception {
        this.pausedByUs = true;
        this.scheduler.pause();
    }

    protected String renderDescription() throws Exception {
        return this.scheduler.renderStatusMessage();
    }

    protected String renderStatus() throws Exception {
        return this.render("scheduling.scheduler-status.vm", new TemplateParameters().set("detail", (Object)this.scheduler.renderDetailMessage()));
    }
}

